/*
 * Decompiled with CFR 0.152.
 */
package android.samutils.fasterserializer.processor;

import android.samutils.fasterserializer.processor.FileGeneratorHelper;
import android.samutils.fasterserializer.processor.Value;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;

public final class ObjectMapperGenerator {
    private static final Map<TypeKind, String> TYPE_KIND_TO_CLASS_NAME = new EnumMap<TypeKind, String>(TypeKind.class){
        {
            this.put(TypeKind.BOOLEAN, Boolean.TYPE.getSimpleName());
            this.put(TypeKind.INT, Integer.TYPE.getSimpleName());
            this.put(TypeKind.DOUBLE, Double.TYPE.getSimpleName());
            this.put(TypeKind.FLOAT, Float.TYPE.getSimpleName());
            this.put(TypeKind.LONG, Long.TYPE.getSimpleName());
            this.put(TypeKind.BYTE, Byte.TYPE.getSimpleName());
        }
    };
    private static final Map<TypeKind, String> TYPE_KIND_TO_GET_METHOD = new EnumMap<TypeKind, String>(TypeKind.class){
        {
            this.put(TypeKind.BOOLEAN, "JacksonJsoner.tryParseBoolean(json)");
            this.put(TypeKind.INT, "JacksonJsoner.tryParseInteger(json)");
            this.put(TypeKind.DOUBLE, "JacksonJsoner.tryParseDouble(json)");
            this.put(TypeKind.FLOAT, "JacksonJsoner.tryParseFloat(json)");
            this.put(TypeKind.LONG, "JacksonJsoner.tryParseLong(json)");
            this.put(TypeKind.BYTE, "JacksonJsoner.tryParseByte(json)");
            this.put(TypeKind.DECLARED, "JacksonJsoner.readObject(json,source,?.class)");
        }
    };
    private static final Map<TypeKind, String> PARCEL_TYPE_KIND_TO_GET_METHOD = new EnumMap<TypeKind, String>(TypeKind.class){
        {
            this.put(TypeKind.BOOLEAN, "parcel.readByte() == (byte)1");
            this.put(TypeKind.INT, "parcel.readInt()");
            this.put(TypeKind.DOUBLE, "parcel.readDouble()");
            this.put(TypeKind.FLOAT, "parcel.readFloat()");
            this.put(TypeKind.LONG, "parcel.readLong()");
            this.put(TypeKind.BYTE, "parcel.readByte()");
            this.put(TypeKind.DECLARED, "Serializer.read(parcel, ?.class)");
        }
    };
    private static final Map<TypeKind, String> PARCEL_TYPE_KIND_TO_WRITE_METHOD = new EnumMap<TypeKind, String>(TypeKind.class){
        {
            this.put(TypeKind.BOOLEAN, "parcel.writeByte(?+(byte)1:(byte)0)");
            this.put(TypeKind.INT, "parcel.writeInt(?)");
            this.put(TypeKind.DOUBLE, "parcel.writeDouble(?)");
            this.put(TypeKind.FLOAT, "parcel.writeFloat(?)");
            this.put(TypeKind.LONG, "parcel.writeLong(?)");
            this.put(TypeKind.BYTE, "parcel.writeByte(?)");
            this.put(TypeKind.DECLARED, "Serializer.write(parcel, ?, _.class)");
        }
    };
    private static final Map<String, String> TYPE_KIND_TO_ARRAY_GET_METHOD = new HashMap<String, String>(){
        {
            this.put(Boolean.TYPE.getSimpleName(), "JacksonJsoner.readBooleanArray(json)");
            this.put(Integer.TYPE.getSimpleName(), "JacksonJsoner.readIntArray(json)");
            this.put(Byte.TYPE.getSimpleName(), "JacksonJsoner.readByteArray(json)");
            this.put(Character.TYPE.getSimpleName(), "JacksonJsoner.readCharArray(json)");
            this.put(Long.TYPE.getSimpleName(), "JacksonJsoner.readLongArray(json)");
            this.put(Float.TYPE.getSimpleName(), "JacksonJsoner.readFloatArray(json)");
            this.put(Double.TYPE.getSimpleName(), "JacksonJsoner.readDoubleArray(json)");
            this.put(Enum.class.getSimpleName(), "JacksonJsoner.readEnumArray(json,?.class)");
            this.put(Array.class.getSimpleName(), "JacksonJsoner.<?>readArray(json, source, ?.class).toArray(new ?[0])");
        }
    };
    private static final Map<String, String> PARCEL_TYPE_KIND_TO_ARRAY_GET_METHOD = new HashMap<String, String>(){
        {
            this.put(Boolean.TYPE.getSimpleName(), "Serializer.readBooleanArray(parcel)");
            this.put("java.lang.String", "Serializer.readStringArray(parcel)");
            this.put(Integer.TYPE.getSimpleName(), "Serializer.readIntArray(parcel)");
            this.put(Byte.TYPE.getSimpleName(), "Serializer.readByteArray(parcel)");
            this.put(Character.TYPE.getSimpleName(), "Serializer.readCharArray(parcel)");
            this.put(Long.TYPE.getSimpleName(), "Serializer.readLongArray(parcel)");
            this.put(Float.TYPE.getSimpleName(), "Serializer.readFloatArray(parcel)");
            this.put(Double.TYPE.getSimpleName(), "Serializer.readDoubleArray(parcel)");
            this.put(Enum.class.getSimpleName(), "Serializer.readEnumArray(parcel, ?.class)");
            this.put(Array.class.getSimpleName(), "Serializer.<?>readArray(parcel, ?.class)");
        }
    };
    private static final Map<String, String> PARCEL_TYPE_KIND_TO_ARRAY_WRITE_METHOD = new HashMap<String, String>(){
        {
            this.put(Boolean.TYPE.getSimpleName(), "Serializer.writeBooleanArray(parcel, ?)");
            this.put("java.lang.String", "Serializer.writeStringArray(parcel, ?)");
            this.put(Integer.TYPE.getSimpleName(), "Serializer.writeIntArray(parcel, ?)");
            this.put(Byte.TYPE.getSimpleName(), "Serializer.writeByteArray(parcel, ?)");
            this.put(Character.TYPE.getSimpleName(), "Serializer.writeCharArray(parcel, ?)");
            this.put(Long.TYPE.getSimpleName(), "Serializer.writeLongArray(parcel, ?)");
            this.put(Float.TYPE.getSimpleName(), "Serializer.writeFloatArray(parcel, ?)");
            this.put(Double.TYPE.getSimpleName(), "Serializer.writeDoubleArray(parcel, ?)");
            this.put(Enum.class.getSimpleName(), "Serializer.writeEnumArray(parcel, %, ?.class)");
            this.put(Array.class.getSimpleName(), "Serializer.writeArray(parcel, %, ?.class)");
        }
    };
    private static final Map<TypeKind, String> TYPE_KIND_TO_FIELD_INFO_CLASS = new EnumMap<TypeKind, String>(TypeKind.class){
        {
            this.put(TypeKind.BOOLEAN, "FieldInfoBoolean");
            this.put(TypeKind.INT, "FieldInfoInt");
            this.put(TypeKind.DOUBLE, "FieldInfoDouble");
            this.put(TypeKind.FLOAT, "FieldInfoFloat");
            this.put(TypeKind.LONG, "FieldInfoLong");
            this.put(TypeKind.BYTE, "FieldInfoByte");
            this.put(TypeKind.ARRAY, "FieldInfo");
            this.put(TypeKind.DECLARED, "FieldInfo");
        }
    };
    private static final String ABSTRACT_FILE_NAME = "ObjectMap";
    private static final String VALUE_MAP_FILE_NAME = "ValueMapFiller";
    private static final String ENUM_TOKENS_FILE_NAME = "EnumTokensMapFiller";
    private static final String UNIQUE_FIELDS_FILE_NAME = "UniqueFieldsMapFiller";

    public ObjectMapperGenerator(Collection<? extends Element> elements, ProcessingEnvironment processingEnvironment) {
        System.out.println("Value: " + elements);
        if (elements != null && !elements.isEmpty()) {
            HashMap<String, HashSet<Element>> dataClasses = new HashMap<String, HashSet<Element>>();
            ArrayList<String> enumClasses = new ArrayList<String>();
            HashMap<String, ArrayList<Element>> uniqueFields = new HashMap<String, ArrayList<Element>>();
            for (Element element : elements) {
                String className = element.getEnclosingElement().asType().toString().replaceAll("<.*?>", "");
                Value value = element.getAnnotation(Value.class);
                if (value.uniqueField()) {
                    ArrayList<Element> unique = (ArrayList<Element>)uniqueFields.get(className);
                    if (unique == null) {
                        unique = new ArrayList<Element>();
                    }
                    unique.add(element);
                    uniqueFields.put(className, unique);
                }
                if (value == null || value.skipReadWrite()) continue;
                HashSet<Element> data = (HashSet<Element>)dataClasses.get(className);
                if (data == null) {
                    data = new HashSet<Element>();
                    dataClasses.put(className, data);
                }
                data.add(element);
                String elementName = element.asType().toString().replace("[", "").replace("]", "");
                if (!value.fieldIsEnum()) continue;
                enumClasses.add(elementName);
            }
            HashMap<String, String> objectMapFiles = new HashMap<String, String>();
            for (String className : dataClasses.keySet()) {
                Set fields = (Set)dataClasses.get(className);
                String fileName = ObjectMapperGenerator.generateObjectMap(className, fields, processingEnvironment);
                objectMapFiles.put(className, fileName);
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("android.samutils.fasterserializer.mapping.value.ValueMap");
            hashSet.add("java.util.HashMap");
            hashSet.add("android.samutils.fasterserializer.mapping.JacksonJsoner");
            StringBuilder builderValueMapFiller = new StringBuilder();
            builderValueMapFiller.append("\t@Override\n").append("\tpublic void fill(final HashMap<Class<?>, JacksonJsoner.ObjectMap<String, JacksonJsoner.IFieldInfo>> mValues) {\n");
            for (String className : objectMapFiles.keySet()) {
                builderValueMapFiller.append("\t\tmValues.put(").append(className).append(".class, new ").append((String)objectMapFiles.get(className)).append("());\n");
            }
            builderValueMapFiller.append("\t}\n");
            if (!dataClasses.isEmpty()) {
                FileGeneratorHelper.writeFile(hashSet, builderValueMapFiller.toString(), VALUE_MAP_FILE_NAME, "ValueMap", processingEnvironment.getFiler());
            }
            HashSet<String> imports2 = new HashSet<String>();
            imports2.add("android.samutils.fasterserializer.mapping.value.EnumTokensMap");
            StringBuilder builderEnumTokensMapFiller = new StringBuilder();
            builderEnumTokensMapFiller.append("\t@Override\n").append("\tpublic void fill() {\n");
            for (String className : enumClasses) {
                builderEnumTokensMapFiller.append("\t\taddEnumTokens(").append(className).append(".class);\n");
            }
            builderEnumTokensMapFiller.append("\t}\n");
            if (!enumClasses.isEmpty()) {
                FileGeneratorHelper.writeFile(imports2, builderEnumTokensMapFiller.toString(), ENUM_TOKENS_FILE_NAME, "EnumTokensMap", processingEnvironment.getFiler());
            }
            HashSet<String> imports3 = new HashSet<String>();
            imports3.add("android.samutils.fasterserializer.mapping.value.UniqueFieldsMap");
            imports3.add("android.samutils.fasterserializer.mapping.value.UniqueKey");
            StringBuilder builderUniqueFieldsMapFiller = new StringBuilder();
            builderUniqueFieldsMapFiller.append("\t@Override\n").append("\tpublic void fill() {\n");
            for (String classWithUniqueFields : uniqueFields.keySet()) {
                List fields = (List)uniqueFields.get(classWithUniqueFields);
                Collections.sort(fields, new Comparator<Element>(){

                    @Override
                    public int compare(Element element, Element t1) {
                        return element.getSimpleName().toString().compareTo(t1.getSimpleName().toString());
                    }
                });
                StringBuilder stringBuilder = new StringBuilder();
                for (Element element : fields) {
                    stringBuilder.append("object.").append(element.getSimpleName()).append("+");
                }
                String[] classNameSplit = classWithUniqueFields.split("\\.");
                String simpleClassName = classNameSplit[classNameSplit.length - 1];
                stringBuilder.append("\"").append(simpleClassName).append("\"");
                builderUniqueFieldsMapFiller.append("\t\taddUniqueKey(").append(classWithUniqueFields).append(".class, new UniqueKey<").append(classWithUniqueFields).append(">() {\n").append("\t\t\t@Override\n").append("\t\t\tpublic String getUniqueKey(final ").append(classWithUniqueFields).append(" object) {\n").append("\t\t\t\treturn ").append(stringBuilder.toString()).append(";\n").append("\t\t\t}\n").append("\t\t});\n");
            }
            builderUniqueFieldsMapFiller.append("\t}\n");
            if (!enumClasses.isEmpty()) {
                FileGeneratorHelper.writeFile(imports3, builderUniqueFieldsMapFiller.toString(), UNIQUE_FIELDS_FILE_NAME, "UniqueFieldsMap", processingEnvironment.getFiler());
            }
        }
    }

    private static String generateObjectMap(String className, Iterable<Element> fields, ProcessingEnvironment processingEnvironment) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(IOException.class.getName());
        imports.add(Map.class.getName());
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.ObjectMap");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.IFieldInfo");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfo");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfoInt");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfoLong");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfoDouble");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfoFloat");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfoBoolean");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner.FieldInfoByte");
        imports.add("android.samutils.fasterserializer.mapping.JacksonJsoner");
        imports.add("android.samutils.fasterserializer.mapping.Serializer");
        imports.add("android.samutils.utils.ArrayUtils");
        imports.add("java.util.Collection");
        imports.add("java.util.Map");
        imports.add("com.fasterxml.jackson.core.JsonParser");
        imports.add("com.fasterxml.jackson.databind.JsonNode");
        imports.add("android.samutils.fasterserializer.mapping.Parcel");
        StringBuilder builder = new StringBuilder();
        builder.append(" @Override public <T> T create(final Class<T> cls) { return (T) new ").append(className).append("(); }\n\n ").append(" @Override public <T> T[] createArray(final int count) { return (T[]) new ").append(className).append("[count]; }\n\n ").append("\t@Override\n").append("\tpublic void fill(final Map mMap) {\n");
        HashMap<String, String> allFields = new HashMap<String, String>();
        HashMap<String, String> versions = new HashMap<String, String>();
        for (Element element : fields) {
            TypeKind typeKind = element.asType().getKind();
            String fieldName = element.getSimpleName().toString();
            String fieldType = ObjectMapperGenerator.getFieldType(element);
            String className1 = element.getEnclosingElement().asType().toString().replaceAll("<.*?>", "");
            String fieldInfoClassName = ObjectMapperGenerator.getFieldFieldInfoClassName(typeKind, className1, fieldType);
            String readJsonMethod = "obj." + fieldName + " = " + ObjectMapperGenerator.getGetJsonMethod(element) + ";";
            String readParcelMethod = "obj." + fieldName + " = " + ObjectMapperGenerator.getGetParcelMethod(element) + ";";
            String writeParcelMethod = ObjectMapperGenerator.getWriteParcel(element).replace("?", "obj." + fieldName).replace("%", "obj." + fieldName).replace("+", "?") + ";";
            String valueKey = element.getAnnotation(Value.class).jsonKey();
            String jsonKey = valueKey == null || valueKey.length() == 0 ? fieldName : valueKey;
            String addFieldCall = String.format(Locale.getDefault(), "\n\t\tmMap.put(\"%1s\", %2s{\n\t\t\t\t\n\t\t\t\t@Override\n\t\t\t\tpublic void read(final %3s obj, final JsonParser json, final JsonNode source) throws IOException {\n\t\t\t\t\t\t%4s\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t@Override\n\t\t\t\tpublic void read(final %5s obj, final Parcel parcel) {\n\t\t\t\t\t\t%6s\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t@Override\n\t\t\t\tpublic void write(final %7s obj, final Parcel parcel) {\n\t\t\t\t\t\t%8s\n\t\t\t\t}\n\t\t\t\t@Override\n\t\t\t\tpublic String getName()  {\n\t\t\t\t\t\treturn \"%9s\";\n\t\t\t\t}\n\t\t});\n\n", jsonKey, fieldInfoClassName, className1, readJsonMethod, className1, readParcelMethod, className1, writeParcelMethod, className1 + "." + jsonKey);
            allFields.put(jsonKey, addFieldCall);
            versions.put(jsonKey, fieldType);
        }
        ArrayList allKeys = new ArrayList(allFields.keySet());
        Collections.sort(allKeys);
        StringBuilder versionBuilder = new StringBuilder();
        for (int i = 0; i < allKeys.size(); ++i) {
            builder.append((String)allFields.get(allKeys.get(i)));
            versionBuilder.append((String)versions.get(allKeys.get(i)));
        }
        builder.append("\t}\n");
        builder.append(" @Override public int getCurrentVersion() { return ").append(versionBuilder.toString().hashCode()).append("; }\n\n ");
        String[] packages = className.split("\\.");
        String fileName = packages[packages.length - 1] + ABSTRACT_FILE_NAME;
        String extendsFileName = "ObjectMap<String, IFieldInfo>";
        FileGeneratorHelper.writeFile(imports, builder.toString(), fileName, "ObjectMap<String, IFieldInfo>", processingEnvironment.getFiler());
        return fileName;
    }

    private static String getFieldFieldInfoClassName(TypeKind fieldTypeKind, String className, String fieldType) {
        StringBuilder builder = new StringBuilder("new ").append(TYPE_KIND_TO_FIELD_INFO_CLASS.get((Object)fieldTypeKind)).append("<").append(className);
        if (!fieldTypeKind.isPrimitive()) {
            builder.append(", ").append(fieldType);
        }
        builder.append(">()");
        return builder.toString();
    }

    private static String getFieldType(Element field) {
        TypeKind fieldTypeKind = field.asType().getKind();
        if (!fieldTypeKind.isPrimitive()) {
            return field.asType().toString();
        }
        return TYPE_KIND_TO_CLASS_NAME.get((Object)fieldTypeKind);
    }

    private static String getGetJsonMethod(Element field) {
        String type = field.asType().toString();
        TypeKind typeKind = field.asType().getKind();
        if (type.equals(String.class.getName())) {
            return "json.getValueAsString()";
        }
        if (field.getAnnotation(Value.class).fieldIsEnum()) {
            if (typeKind == TypeKind.ARRAY) {
                type = type.replace("[", "").replace("]", "");
                return TYPE_KIND_TO_ARRAY_GET_METHOD.get(Enum.class.getSimpleName()).replace("?", type);
            }
            return "JacksonJsoner.readEnum(json.getValueAsString(), ?.class);".replace("?", type);
        }
        if (typeKind == TypeKind.ARRAY) {
            if (TYPE_KIND_TO_ARRAY_GET_METHOD.containsKey(type = type.replace("[", "").replace("]", ""))) {
                return TYPE_KIND_TO_ARRAY_GET_METHOD.get(type);
            }
            return TYPE_KIND_TO_ARRAY_GET_METHOD.get(Array.class.getSimpleName()).replace("?", type);
        }
        return TYPE_KIND_TO_GET_METHOD.get((Object)typeKind).replace("?", type);
    }

    private static String getGetParcelMethod(Element field) {
        String type = field.asType().toString();
        TypeKind typeKind = field.asType().getKind();
        if (type.equals(String.class.getName())) {
            return "parcel.readString()";
        }
        if (field.getAnnotation(Value.class).fieldIsEnum()) {
            if (typeKind == TypeKind.ARRAY) {
                type = type.replace("[", "").replace("]", "");
                return PARCEL_TYPE_KIND_TO_ARRAY_GET_METHOD.get(Enum.class.getSimpleName()).replace("?", type);
            }
            return "Serializer.readEnum(parcel, ?.class)".replace("?", type);
        }
        if (typeKind == TypeKind.ARRAY) {
            if (PARCEL_TYPE_KIND_TO_ARRAY_GET_METHOD.containsKey(type = type.replace("[", "").replace("]", ""))) {
                return PARCEL_TYPE_KIND_TO_ARRAY_GET_METHOD.get(type);
            }
            return PARCEL_TYPE_KIND_TO_ARRAY_GET_METHOD.get(Array.class.getSimpleName()).replace("?", type);
        }
        return PARCEL_TYPE_KIND_TO_GET_METHOD.get((Object)typeKind).replace("?", type);
    }

    private static String getWriteParcel(Element field) {
        String type = field.asType().toString();
        TypeKind typeKind = field.asType().getKind();
        if (type.equals(String.class.getName())) {
            return "parcel.writeString(?)";
        }
        if (field.getAnnotation(Value.class).fieldIsEnum()) {
            if (typeKind == TypeKind.ARRAY) {
                type = type.replace("[", "").replace("]", "");
                return PARCEL_TYPE_KIND_TO_ARRAY_WRITE_METHOD.get(Enum.class.getSimpleName()).replace("?", type);
            }
            return "Serializer.writeEnum(parcel, ?)";
        }
        if (typeKind == TypeKind.ARRAY) {
            if (PARCEL_TYPE_KIND_TO_ARRAY_WRITE_METHOD.containsKey(type = type.replace("[", "").replace("]", ""))) {
                return PARCEL_TYPE_KIND_TO_ARRAY_WRITE_METHOD.get(type);
            }
            return PARCEL_TYPE_KIND_TO_ARRAY_WRITE_METHOD.get(Array.class.getSimpleName()).replace("?", type);
        }
        return PARCEL_TYPE_KIND_TO_WRITE_METHOD.get((Object)typeKind).replace("_", type);
    }
}

