/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.view;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.rapid.log.LogUtil;
import android.rapid.view.ActivityInject;
import android.rapid.view.ViewInject;
import android.view.View;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public final class raInjects {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("raInjects");

    private static void injectRes(InjectObj injectObj, Field field) throws Exception {
        ResId outlet = field.getAnnotation(ResId.class);
        if (null == outlet) {
            return;
        }
        int resId = outlet.id();
        Resources res = injectObj.getResources();
        String typeName = res.getResourceTypeName(resId);
        Object value = null;
        if ("string".equals(typeName)) {
            value = res.getString(resId);
        } else if ("drawable".equals(typeName)) {
            value = res.getDrawable(resId);
        } else if ("dimen".equals(typeName)) {
            value = Float.valueOf(res.getDimension(resId));
        } else if ("color".equals(typeName)) {
            Class<?> fieldType = field.getType();
            value = ColorStateList.class.isAssignableFrom(fieldType) ? res.getColorStateList(resId) : Integer.valueOf(res.getColor(resId));
        } else if ("array".equals(typeName)) {
            Class<?> fieldType = field.getType();
            if (String[].class.isAssignableFrom(fieldType)) {
                value = res.getStringArray(resId);
            } else if (int[].class.isAssignableFrom(fieldType)) {
                value = res.getIntArray(resId);
            }
        }
        field.set(injectObj.getObject(), value);
    }

    private static void injectView(InjectObj injectObj, Field field) throws Exception {
        ViewId outlet = field.getAnnotation(ViewId.class);
        if (null == outlet) {
            return;
        }
        int viewId = outlet.id();
        View view = injectObj.injectView(viewId);
        field.set(injectObj.getObject(), view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void inject(InjectObj injectObj) {
        Field[] fields;
        for (Field field : fields = injectObj.getObject().getClass().getDeclaredFields()) {
            boolean f = field.isAccessible();
            field.setAccessible(true);
            try {
                raInjects.injectView(injectObj, field);
                raInjects.injectRes(injectObj, field);
            }
            catch (Exception e) {
                LogUtil.e(TAG, "inject", e);
            }
            finally {
                field.setAccessible(f);
            }
        }
    }

    public static void inject(View view) {
        raInjects.inject(new ViewInject(view));
    }

    public static void inject(Object obj, View view) {
        raInjects.inject(new ViewInject(obj, view));
    }

    public static void inject(Activity activity) {
        raInjects.inject(new ActivityInject(activity));
    }

    public static void inject(Object obj, Activity activity) {
        raInjects.inject(new ActivityInject(obj, activity));
    }

    public static interface InjectObj {
        public Object getObject();

        public Resources getResources();

        public View injectView(int var1);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ViewId {
        public int id();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ResId {
        public int id();
    }
}

