/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.task;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.rapid.log.LogUtil;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class raAsyncTask<Params, Result> {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("raAsyncTask");
    private raResult<Result> mTarget;
    private WorkerRunnable<Params, Result> mWorker;
    private FutureTask<Result> mFuture;
    public static final Executor SERIAL_EXECUTOR;
    private static volatile Executor sDefaultExecutor;
    private static final int CPU_COUNT;
    private static final int CORE_POOL_SIZE;
    private static final int MAXIMUM_POOL_SIZE;
    private static final int KEEP_ALIVE = 1;
    private static final int MESSAGE_POST_RESULT = 1;
    private static final ThreadFactory sThreadFactory;
    private static final BlockingQueue<Runnable> sPoolWorkQueue;
    public static final Executor THREAD_POOL_EXECUTOR;
    private static InternalHandler sHandler;
    private final AtomicBoolean mCancelled = new AtomicBoolean();
    private final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    private raAsyncTask(final raTask<Params, Result> task, final Params params) {
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                return raAsyncTask.this.postResult(task.execute(params));
            }
        };
        this.mWorker.mParams = params;
    }

    public static <Params, Result> raAsyncTask<Params, Result> createTask(raTask<Params, Result> task, Params params) {
        return new raAsyncTask<Params, Result>(task, params);
    }

    public void subscibe(final raResult<Result> target) {
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                try {
                    raAsyncTask.this.postResultIfNotInvoked(this.get());
                }
                catch (InterruptedException e) {
                    LogUtil.e(TAG, "InterruptedException", e);
                }
                catch (ExecutionException e) {
                    target.onError(e);
                }
                catch (CancellationException e) {
                    raAsyncTask.this.postResultIfNotInvoked(null);
                }
            }
        };
        this.mTarget = target;
        sDefaultExecutor.execute(this.mFuture);
    }

    private final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel() {
        this.mCancelled.set(true);
        return this.mFuture.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Class<raAsyncTask> clazz = raAsyncTask.class;
        synchronized (raAsyncTask.class) {
            if (sHandler == null) {
                sHandler = new InternalHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    private void postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private Result postResult(Result result) {
        Message message = raAsyncTask.getHandler().obtainMessage(1, new AsyncTaskResult<Result>(this, result));
        message.sendToTarget();
        return result;
    }

    private void finish(Result result) {
        if (this.isCancelled()) {
            this.mTarget.onCancelled(result);
        } else {
            this.mTarget.onResult(result);
        }
    }

    static {
        sDefaultExecutor = SERIAL_EXECUTOR = new SerialExecutor();
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = CPU_COUNT + 1;
        MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
        sThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "raAsyncTask #" + this.mCount.getAndIncrement());
            }
        };
        sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
        THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    }

    private static class SerialExecutor
    implements Executor {
        final ArrayDeque<Runnable> mTasks = new ArrayDeque();
        Runnable mActive;

        private SerialExecutor() {
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        SerialExecutor.this.scheduleNext();
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                THREAD_POOL_EXECUTOR.execute(this.mActive);
            }
        }
    }

    private static class AsyncTaskResult<Data> {
        final raAsyncTask mTask;
        final Data mData;

        AsyncTaskResult(raAsyncTask task, Data data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    private static class InternalHandler
    extends Handler {
        public InternalHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            AsyncTaskResult result = (AsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result.mTask.finish(result.mData);
                }
            }
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params mParams;

        private WorkerRunnable() {
        }
    }

    public static interface raResult<Result> {
        public void onCancelled(Result var1);

        public void onError(Throwable var1);

        public void onResult(Result var1);
    }

    public static interface raTask<Params, Result> {
        public Result execute(Params var1) throws Exception;
    }
}

