/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.reflect;

import android.os.Build;
import android.rapid.log.LogUtil;
import android.util.ArrayMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class raReflect {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("raReflect");
    private static Map<String, Class> mClassMap;
    private static Map<String, Method> mMethodMap;

    public static Object newInstance(Class<?> clazz, Object[] params) throws Exception {
        if (params != null && params.length > 0) {
            Constructor<?> con = clazz.getConstructor(raReflect.getParamsTypes(params));
            return con.newInstance(params);
        }
        Constructor<?> con = clazz.getConstructor(new Class[0]);
        Object obj = con.newInstance(new Object[0]);
        return obj;
    }

    public static Object newInstance(Class<?> clazz, Class<?>[] paramsTypes, Object[] params) throws Exception {
        if (params != null && params.length > 0) {
            Constructor<?> con = clazz.getConstructor(paramsTypes);
            return con.newInstance(params);
        }
        Constructor<?> con = clazz.getConstructor(new Class[0]);
        Object obj = con.newInstance(new Object[0]);
        return obj;
    }

    public static Object invoke(Object obj, String methodName, Object[] params) throws Exception {
        return raReflect.invoke(obj.getClass(), obj, methodName, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object invoke(Class<?> objClass, Object obj, String methodName, Object[] params) throws Exception {
        if (params == null || params.length == 0) {
            Map<String, Method> map = mMethodMap;
            synchronized (map) {
                Method method = mMethodMap.get(methodName);
                if (method == null) {
                    method = objClass.getMethod(methodName, new Class[0]);
                    method.setAccessible(true);
                    mMethodMap.put(methodName, method);
                }
                return method.invoke(obj, new Object[0]);
            }
        }
        Map<String, Method> map = mMethodMap;
        synchronized (map) {
            Class<?>[] clazzes = raReflect.getParamsTypes(params);
            StringBuilder sb = new StringBuilder(objClass.getName());
            sb.append('#');
            sb.append(methodName);
            sb.append(raReflect.getParamsTypesString(clazzes));
            sb.append("#bestmatch");
            String fullName = sb.toString();
            Method method = mMethodMap.get(fullName);
            if (method == null) {
                method = objClass.getMethod(methodName, clazzes);
                method.setAccessible(true);
                mMethodMap.put(fullName, method);
            }
            return method.invoke(obj, params);
        }
    }

    public static boolean setField(Object desObj, Class<?> desClass, String fieldName, Object value) {
        if (desObj == null || desClass == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        try {
            Field field = desClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(desObj, value);
            return true;
        }
        catch (Exception ignore) {
            LogUtil.e(TAG, "setField Exception", ignore);
            return false;
        }
    }

    public static boolean setField(Object desObj, String fieldName, Object value) {
        if (desObj == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> desClass = desObj.getClass();
        return raReflect.setFieldStepwise(desObj, desClass, fieldName, value);
    }

    private static boolean setFieldStepwise(Object desObj, Class<?> rootClass, String fieldName, Object value) {
        Class<?> desClass = rootClass;
        while (desClass != null) {
            if (raReflect.setField(desObj, desClass, fieldName, value)) {
                return true;
            }
            try {
                desClass = desClass.getSuperclass();
            }
            catch (Exception e) {
                desClass = null;
            }
        }
        return false;
    }

    public static boolean setStaticField(String className, String fieldName, Object value) {
        if (className == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> objClass = mClassMap.get(className);
        if (objClass == null) {
            try {
                objClass = Class.forName(className);
                mClassMap.put(className, objClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("className not found");
            }
        }
        return raReflect.setFieldStepwise(objClass, objClass, fieldName, value);
    }

    public static Object getField(Object desObj, Class<?> desClass, String fieldName) throws NoSuchFieldException {
        if (desObj == null || desClass == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        try {
            Field field = desClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(desObj);
        }
        catch (Exception ignore) {
            throw new NoSuchFieldException(fieldName);
        }
    }

    public static Object getField(Object desObj, String fieldName) throws NoSuchFieldException {
        if (desObj == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> desClass = desObj.getClass();
        return raReflect.getFieldStepwise(desObj, desClass, fieldName);
    }

    private static Object getFieldStepwise(Object desObj, Class<?> rootClass, String fieldName) throws NoSuchFieldException {
        Class<?> desClass = rootClass;
        while (desClass != null) {
            try {
                return raReflect.getField(desObj, desClass, fieldName);
            }
            catch (NoSuchFieldException ignore) {
                try {
                    desClass = desClass.getSuperclass();
                }
                catch (Exception e) {
                    desClass = null;
                }
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static Object getStaticField(String className, String fieldName) throws NoSuchFieldException {
        if (className == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> objClass = mClassMap.get(className);
        if (objClass == null) {
            try {
                objClass = Class.forName(className);
                mClassMap.put(className, objClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("className not found");
            }
        }
        return raReflect.getFieldStepwise(objClass, objClass, fieldName);
    }

    private static Class<?>[] getParamsTypes(Object[] params) {
        Class[] paramsType = new Class[params.length];
        for (int i = 0; i < paramsType.length; ++i) {
            paramsType[i] = params[i].getClass();
        }
        return paramsType;
    }

    private static String getParamsTypesString(Class<?> ... clazzes) {
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (Class<?> clazz : clazzes) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (clazz != null) {
                sb.append(clazz.getCanonicalName());
                continue;
            }
            sb.append("null");
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        if (Build.VERSION.SDK_INT >= 19) {
            mClassMap = new ArrayMap();
            mMethodMap = new ArrayMap();
        } else {
            mClassMap = new HashMap<String, Class>();
            mMethodMap = new HashMap<String, Method>();
        }
    }
}

