/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.net;

import android.rapid.net.NetworkResponse;
import android.rapid.net.Response;
import android.rapid.net.exception.ParseError;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class Request<T> {
    private static final String DEFAULT_PARAMS_ENCODING = "UTF-8";
    private final int mMethod;
    private final String mUrl;

    public Request(String url) {
        this(0, url);
    }

    public Request(int method, String url) {
        this.mMethod = method;
        this.mUrl = url;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1) throws ParseError;

    public int getMethod() {
        return this.mMethod;
    }

    public String getUrl() {
        return this.mUrl;
    }

    protected String getParamsEncoding() {
        return DEFAULT_PARAMS_ENCODING;
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    protected Map<String, String> getParams() {
        return null;
    }

    public byte[] getBody() {
        Map<String, String> params = this.getParams();
        if (params != null && params.size() > 0) {
            return this.encodeParameters(params, this.getParamsEncoding());
        }
        return null;
    }

    public int getTimeoutMs() {
        return 5000;
    }

    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    private byte[] encodeParameters(Map<String, String> params, String paramsEncoding) {
        StringBuilder encodedParams = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                encodedParams.append(URLEncoder.encode(entry.getKey(), paramsEncoding));
                encodedParams.append('=');
                encodedParams.append(URLEncoder.encode(entry.getValue(), paramsEncoding));
                encodedParams.append('&');
            }
            return encodedParams.toString().getBytes(paramsEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Encoding not supported: " + paramsEncoding, uee);
        }
    }

    public static interface Method {
        public static final int GET = 0;
        public static final int POST = 1;
    }
}

