/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.net;

import android.rapid.net.IHttpClient;
import android.rapid.net.Request;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientV2
implements IHttpClient {
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected final HttpClient mClient;

    public HttpClientV2(HttpClient client) {
        this.mClient = client;
    }

    private static void addHeaders(HttpUriRequest httpRequest, Map<String, String> headers) {
        for (String key : headers.keySet()) {
            httpRequest.setHeader(key, headers.get(key));
        }
    }

    private static void setEntityIfNonEmptyBody(HttpEntityEnclosingRequestBase httpRequest, Request<?> request) {
        byte[] body = request.getBody();
        if (body != null) {
            ByteArrayEntity entity = new ByteArrayEntity(body);
            httpRequest.setEntity((HttpEntity)entity);
        }
    }

    @Override
    public HttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws IOException {
        HttpUriRequest httpRequest = this.createHttpRequest(request, additionalHeaders);
        HttpClientV2.addHeaders(httpRequest, additionalHeaders);
        HttpClientV2.addHeaders(httpRequest, request.getHeaders());
        this.onPrepareRequest(httpRequest);
        HttpParams httpParams = httpRequest.getParams();
        int timeoutMs = request.getTimeoutMs();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutMs);
        return this.mClient.execute(httpRequest);
    }

    protected void onPrepareRequest(HttpUriRequest request) throws IOException {
    }

    private HttpUriRequest createHttpRequest(Request<?> request, Map<String, String> additionalHeaders) {
        switch (request.getMethod()) {
            case 0: {
                return new HttpGet(request.getUrl());
            }
            case 1: {
                HttpPost postRequest = new HttpPost(request.getUrl());
                postRequest.addHeader(HEADER_CONTENT_TYPE, request.getBodyContentType());
                HttpClientV2.setEntityIfNonEmptyBody((HttpEntityEnclosingRequestBase)postRequest, request);
                return postRequest;
            }
        }
        throw new IllegalStateException("Unknown request method.");
    }
}

