/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.log;

import android.os.Build;
import android.util.Log;
import java.util.Formatter;
import java.util.Locale;

public final class LogUtil {
    public static final String RAPID_LOGTAG_PREFIX = "ra_";
    private static final Tag TAG = new Tag("Log");

    public static void d(Tag tag, String msg) {
        if (LogUtil.isLogable(tag, 3)) {
            Log.d((String)tag.toString(), (String)msg);
        }
    }

    public static void d(Tag tag, String msg, Throwable tr) {
        if (LogUtil.isLogable(tag, 3)) {
            Log.d((String)tag.toString(), (String)msg, (Throwable)tr);
        }
    }

    public static void e(Tag tag, String msg) {
        if (LogUtil.isLogable(tag, 6)) {
            Log.e((String)tag.toString(), (String)msg);
        }
    }

    public static void e(Tag tag, String msg, Throwable tr) {
        if (LogUtil.isLogable(tag, 6)) {
            Log.e((String)tag.toString(), (String)msg, (Throwable)tr);
        }
    }

    public static void i(Tag tag, String msg) {
        if (LogUtil.isLogable(tag, 4)) {
            Log.i((String)tag.toString(), (String)msg);
        }
    }

    public static void i(Tag tag, String msg, Throwable tr) {
        if (LogUtil.isLogable(tag, 4)) {
            Log.i((String)tag.toString(), (String)msg, (Throwable)tr);
        }
    }

    public static void v(Tag tag, String msg) {
        if (LogUtil.isLogable(tag, 2)) {
            Log.v((String)tag.toString(), (String)msg);
        }
    }

    public static void v(Tag tag, String msg, Throwable tr) {
        if (LogUtil.isLogable(tag, 2)) {
            Log.v((String)tag.toString(), (String)msg, (Throwable)tr);
        }
    }

    public static void w(Tag tag, String msg) {
        if (LogUtil.isLogable(tag, 5)) {
            Log.w((String)tag.toString(), (String)msg);
        }
    }

    public static void w(Tag tag, String msg, Throwable tr) {
        if (LogUtil.isLogable(tag, 5)) {
            Log.w((String)tag.toString(), (String)msg, (Throwable)tr);
        }
    }

    public static void value(Tag tag, String format, Object ... args) {
        Formatter formatter = new Formatter(Locale.getDefault()).format(format, args);
        Log.d((String)tag.toString(), (String)formatter.toString());
    }

    private static boolean isLogable(Tag tag, int level) {
        try {
            return LogUtil.isDebugOsBuild() || LogUtil.shouldLog(tag, level);
        }
        catch (IllegalArgumentException ex) {
            LogUtil.e(TAG, "Tag too long:" + tag);
            return false;
        }
    }

    private static boolean shouldLog(Tag tag, int level) {
        return Log.isLoggable((String)RAPID_LOGTAG_PREFIX, (int)level) || Log.isLoggable((String)tag.toString(), (int)level);
    }

    private static boolean isDebugOsBuild() {
        return "userdebug".equals(Build.TYPE) || "eng".equals(Build.TYPE);
    }

    public static final class Tag {
        private static final int MAX_TAG_LEN = 23 - "ra_".length();
        final String mValue;

        public Tag(String tag) {
            int lenDiff = tag.length() - MAX_TAG_LEN;
            if (lenDiff > 0) {
                LogUtil.w(TAG, "Tag " + tag + " is " + lenDiff + " chars longer than limit.");
            }
            this.mValue = LogUtil.RAPID_LOGTAG_PREFIX + (lenDiff > 0 ? tag.substring(0, MAX_TAG_LEN) : tag);
        }

        public String toString() {
            return this.mValue;
        }
    }
}

