/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.database.sqlite;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.rapid.database.sqlite.IDBId;
import android.rapid.log.LogUtil;
import android.rapid.reflect.raReflect;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class raSQLiteHelper<T>
extends SQLiteOpenHelper {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("SQLiteHelper");
    private static final HashMap<Class<?>, String> CLASS_TYPES = new HashMap();
    private HashMap<String, Class<?>> mColumn = new HashMap();
    private String mTableName;
    private final Class<?> Tclass;

    public raSQLiteHelper(Context context, String dbname, Class<T> t) {
        super(context, dbname, null, 1);
        this.Tclass = t;
        this.mTableName = this.Tclass.getSimpleName();
        this.registerObjectByIDBId(this.Tclass);
    }

    public void setTableName(String name) {
        this.mTableName = name;
    }

    private void registerObjectByIDBId(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    IDBId outlet = field.getAnnotation(IDBId.class);
                    if (outlet == null) continue;
                    String viewId = outlet.id();
                    this.mColumn.put(viewId, field.getType());
                }
                catch (Exception e) {
                    LogUtil.e(TAG, "registerObjectByIDBId exception");
                }
            }
        }
    }

    private HashMap<String, Object> getObjectValueByIDBId(Object classObj) {
        HashMap<String, Object> columnValue = new HashMap<String, Object>();
        Field[] fields = classObj.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    IDBId outlet = field.getAnnotation(IDBId.class);
                    if (outlet == null) continue;
                    String viewId = outlet.id();
                    columnValue.put(viewId, field.get(classObj));
                }
                catch (Exception e) {
                    LogUtil.e(TAG, "getObjectValueByIDBId exception");
                }
            }
        }
        return columnValue;
    }

    public void onCreate(SQLiteDatabase db) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE " + this.mTableName);
        sql.append(" (");
        this.mColumn.remove("_index");
        sql.append("_index INTEGER PRIMARY KEY AUTOINCREMENT,");
        for (Map.Entry<String, Class<?>> entry : this.mColumn.entrySet()) {
            sql.append(entry.getKey() + " " + CLASS_TYPES.get(entry.getValue()));
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        db.execSQL(sql.toString());
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("ALTER TABLE " + this.mTableName + " ADD COLUMN other TEXT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findAll() {
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> columnValue = new HashMap<String, String>();
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor c = null;
        try {
            c = db.rawQuery("SELECT * FROM " + this.mTableName, null);
            while (c.moveToNext()) {
                Object obj = raReflect.newInstance(this.Tclass, null);
                for (String key : this.mColumn.keySet()) {
                    String value = c.getString(c.getColumnIndex(key));
                    columnValue.put(key, value);
                }
                Field[] fields = obj.getClass().getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    for (Field field : fields) {
                        field.setAccessible(true);
                        IDBId outlet = field.getAnnotation(IDBId.class);
                        if (outlet == null) continue;
                        field.set(obj, columnValue.get(outlet.id()));
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            LogUtil.e(TAG, "findAll exception");
        }
        finally {
            if (c != null) {
                c.close();
            }
            db.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findAll(String sql, String[] selectionArgs) {
        SQLiteDatabase db = this.getReadableDatabase();
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap<String, String> columnValue = new HashMap<String, String>();
        Cursor c = null;
        try {
            c = db.rawQuery("SELECT * FROM " + this.mTableName + " WHERE " + sql, selectionArgs);
            while (c.moveToNext()) {
                Object obj = raReflect.newInstance(this.Tclass, null);
                for (String key : this.mColumn.keySet()) {
                    String value = c.getString(c.getColumnIndex(key));
                    columnValue.put(key, value);
                }
                Field[] fields = obj.getClass().getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    for (Field field : fields) {
                        field.setAccessible(true);
                        IDBId outlet = field.getAnnotation(IDBId.class);
                        if (outlet == null) continue;
                        field.set(obj, columnValue.get(outlet.id()));
                    }
                }
                list.add(obj);
            }
        }
        catch (Exception e) {
            LogUtil.e(TAG, "findAll exception", e);
        }
        finally {
            if (c != null) {
                c.close();
            }
            db.close();
        }
        return list;
    }

    public void delAll() {
        try (SQLiteDatabase db = this.getWritableDatabase();){
            db.execSQL("DELETE FROM " + this.mTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delAll(String sql, String[] selectionArgs) {
        try (SQLiteDatabase db = this.getWritableDatabase();){
            db.execSQL("DELETE FROM " + this.mTableName + " WHERE " + sql, (Object[])selectionArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(T t) {
        StringBuilder sql_key = new StringBuilder();
        StringBuilder sql_value = new StringBuilder();
        ArrayList<Object> objects = new ArrayList<Object>();
        sql_key.append("INSERT INTO " + this.mTableName);
        sql_key.append(" (");
        HashMap<String, Object> columnValue = this.getObjectValueByIDBId(t);
        for (Map.Entry<String, Object> entry : columnValue.entrySet()) {
            sql_key.append((Object)entry.getKey());
            sql_key.append(",");
            sql_value.append("?");
            sql_value.append(",");
            objects.add(entry.getValue());
        }
        sql_key.deleteCharAt(sql_key.length() - 1);
        sql_key.append(") ");
        sql_key.append("VALUES (");
        sql_value.deleteCharAt(sql_value.length() - 1);
        sql_value.append(")");
        sql_key.append((CharSequence)sql_value);
        try (SQLiteDatabase db = this.getWritableDatabase();){
            db.execSQL(sql_key.toString(), objects.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(T t) {
        StringBuilder sql_key = new StringBuilder();
        ArrayList<Object> objects = new ArrayList<Object>();
        sql_key.append("UPDATE " + this.mTableName + " SET ");
        HashMap<String, Object> columnValue = this.getObjectValueByIDBId(t);
        Object index = columnValue.get("_index");
        columnValue.remove("_index");
        for (Map.Entry<String, Object> entry : columnValue.entrySet()) {
            sql_key.append((Object)entry.getKey());
            sql_key.append("=?");
            sql_key.append(",");
            objects.add(entry.getValue());
        }
        sql_key.deleteCharAt(sql_key.length() - 1);
        sql_key.append(" WHERE _index=?");
        objects.add(index);
        try (SQLiteDatabase db = this.getWritableDatabase();){
            db.execSQL(sql_key.toString(), objects.toArray());
        }
    }

    static {
        CLASS_TYPES.put(String.class, "TEXT");
        CLASS_TYPES.put(Integer.class, "INTEGER");
        CLASS_TYPES.put(Float.class, "FLOAT");
        CLASS_TYPES.put(Long.class, "BIGINT");
        CLASS_TYPES.put(Double.class, "DOUBLE");
    }
}

