/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.connect.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Handler;
import android.rapid.connect.AbsConnect;
import android.rapid.connect.ConnectDevice;
import android.rapid.connect.IAvailableDeviceListener;
import android.rapid.connect.wifi.WiFiDirectBroadcastReceiver;
import android.rapid.connect.wifi.WifiSocketService;
import java.util.ArrayList;
import java.util.List;

public class raWifiConnect
extends AbsConnect<WifiP2pDevice>
implements WifiP2pManager.ConnectionInfoListener,
WifiP2pManager.PeerListListener {
    private Context mContext;
    private WifiP2pManager mWifiP2pManager;
    private WifiP2pManager.Channel mChannel;
    private WiFiDirectBroadcastReceiver mReceiver;
    private List<ConnectDevice> mDevices = new ArrayList<ConnectDevice>();
    private IAvailableDeviceListener mAvailableDeviceListener;
    private WifiSocketService mSocketService;
    private ConnectDevice mThisDevice;

    public raWifiConnect(Context context, Handler handler) {
        this.mContext = context;
        this.mSocketService = new WifiSocketService(handler);
        this.mWifiP2pManager = (WifiP2pManager)context.getSystemService("wifip2p");
        this.mChannel = this.mWifiP2pManager.initialize(context, context.getMainLooper(), null);
    }

    @Override
    public void enable() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        intentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        this.mReceiver = new WiFiDirectBroadcastReceiver(this);
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
    }

    @Override
    public void disable() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
        this.mSocketService.stop();
    }

    @Override
    public void searchDevcie(IAvailableDeviceListener listener) {
        this.mAvailableDeviceListener = listener;
        this.discoverPeers();
    }

    @Override
    public void connect(ConnectDevice<WifiP2pDevice> device) {
        WifiP2pConfig config = new WifiP2pConfig();
        config.deviceAddress = ((WifiP2pDevice)device.device).deviceAddress;
        config.wps.setup = 0;
        this.mWifiP2pManager.connect(this.mChannel, config, null);
    }

    @Override
    public void cancelConnect() {
        if (this.isConnected()) {
            this.mWifiP2pManager.removeGroup(this.mChannel, null);
        } else {
            this.mWifiP2pManager.cancelConnect(this.mChannel, null);
        }
        this.mSocketService.stop();
    }

    @Override
    public boolean isConnected() {
        return this.mSocketService.getState() == 3;
    }

    @Override
    public void send(byte[] data) {
        if (this.isConnected()) {
            this.mSocketService.write(data);
        }
    }

    @Override
    public List<ConnectDevice> getAvailableDevices() {
        return this.mDevices;
    }

    public void discoverPeers() {
        this.mWifiP2pManager.discoverPeers(this.mChannel, null);
    }

    public void resetPeers() {
        this.mDevices.clear();
    }

    public boolean isWifiP2pAviliable() {
        return this.mWifiP2pManager != null;
    }

    public void requestPeers() {
        this.mWifiP2pManager.requestPeers(this.mChannel, (WifiP2pManager.PeerListListener)this);
    }

    public void requestConnectionInfo() {
        this.mWifiP2pManager.requestConnectionInfo(this.mChannel, (WifiP2pManager.ConnectionInfoListener)this);
    }

    public void onPeersAvailable(WifiP2pDeviceList peers) {
        this.resetPeers();
        for (WifiP2pDevice wifidevice : peers.getDeviceList()) {
            ConnectDevice device = new ConnectDevice();
            device.deviceName = wifidevice.deviceName;
            device.device = wifidevice;
            device.status = wifidevice.status;
            device.connected = wifidevice.status == 0;
            device.deviceStatus = this.getDeviceStatus(wifidevice.status);
            this.mDevices.add(device);
        }
        if (this.mAvailableDeviceListener != null) {
            this.mAvailableDeviceListener.availableDevice(this.mDevices);
        }
    }

    public void onConnectionInfoAvailable(WifiP2pInfo info) {
        if (info.groupFormed && info.isGroupOwner) {
            if (this.mSocketService.getState() == 0) {
                this.mSocketService.start();
            }
        } else if (info.groupFormed) {
            this.mSocketService.connect(info.groupOwnerAddress.getHostAddress());
        }
    }

    private String getDeviceStatus(int deviceStatus) {
        switch (deviceStatus) {
            case 3: {
                return "Available";
            }
            case 1: {
                return "Invited";
            }
            case 0: {
                return "Connected";
            }
            case 2: {
                return "Failed";
            }
            case 4: {
                return "Unavailable";
            }
        }
        return "Unknown";
    }

    public void updateThisDevice(WifiP2pDevice wifidevice) {
        this.mThisDevice = new ConnectDevice();
        this.mThisDevice.device = wifidevice;
        this.mThisDevice.deviceName = wifidevice.deviceName;
        this.mThisDevice.status = wifidevice.status;
        this.mThisDevice.deviceStatus = this.getDeviceStatus(wifidevice.status);
    }

    public ConnectDevice<WifiP2pDevice> getDevice() {
        return this.mThisDevice;
    }
}

