/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.connect.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pDevice;
import android.rapid.connect.wifi.raWifiConnect;

class WiFiDirectBroadcastReceiver
extends BroadcastReceiver {
    private raWifiConnect mWifiConnect;

    public WiFiDirectBroadcastReceiver(raWifiConnect wifiConnect) {
        this.mWifiConnect = wifiConnect;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
            int state = intent.getIntExtra("wifi_p2p_state", -1);
            if (state == 2) {
                this.mWifiConnect.discoverPeers();
            } else {
                this.mWifiConnect.resetPeers();
            }
        } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
            if (this.mWifiConnect.isWifiP2pAviliable()) {
                this.mWifiConnect.requestPeers();
            }
        } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action)) {
            if (!this.mWifiConnect.isWifiP2pAviliable()) {
                return;
            }
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (networkInfo.isConnected()) {
                this.mWifiConnect.requestConnectionInfo();
            } else {
                this.mWifiConnect.resetPeers();
                this.mWifiConnect.discoverPeers();
            }
        } else if ("android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
            WifiP2pDevice wifiP2pDevice = (WifiP2pDevice)intent.getParcelableExtra("wifiP2pDevice");
            this.mWifiConnect.updateThisDevice(wifiP2pDevice);
        }
    }
}

