/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.connect.socket;

import android.rapid.connect.IDispatchListener;
import android.rapid.connect.socket.AbsThread;
import android.rapid.connect.socket.ClientThread;
import android.rapid.connect.socket.DispatchThread;
import android.rapid.connect.socket.ServerThread;
import android.rapid.log.LogUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class raSocketService {
    public static final int STATE_NONE = 0;
    public static final int STATE_LISTEN = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    private static final LogUtil.Tag TAG = new LogUtil.Tag("SocketService");
    private final IDispatchListener mDispatchListener;
    protected AbsThread mAcceptThread;
    protected AbsThread mConnectThread;
    protected AbsThread mConnectedThread;
    private int mState = 0;

    public raSocketService(IDispatchListener handler) {
        this.mDispatchListener = handler;
    }

    public synchronized int getState() {
        return this.mState;
    }

    protected synchronized void setState(int state) {
        LogUtil.d(TAG, "setState() " + this.mState + " -> " + state);
        this.mState = state;
    }

    public synchronized void start() {
        LogUtil.d(TAG, "start");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.setState(1);
        if (this.mAcceptThread == null) {
            this.mAcceptThread = new AcceptThread();
            this.mAcceptThread.start();
        }
    }

    public synchronized void connect(String address) {
        LogUtil.d(TAG, "connect to: " + address);
        if (this.mState == 2 && this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(address);
        this.mConnectThread.start();
        this.setState(2);
    }

    public synchronized void connected(Socket socket) {
        this.cancelThread();
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.setState(3);
    }

    public synchronized void stop() {
        LogUtil.d(TAG, "stop");
        this.cancelThread();
        this.setState(0);
    }

    private void cancelThread() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] out) {
        DispatchThread r;
        raSocketService raSocketService2 = this;
        synchronized (raSocketService2) {
            if (this.mState != 3) {
                return;
            }
            r = (DispatchThread)this.mConnectedThread;
        }
        r.write(out);
    }

    protected void connectionFailed() {
        this.mDispatchListener.connectionFailed();
        this.start();
    }

    protected void connectionLost() {
        this.mDispatchListener.connectionLost();
        this.start();
    }

    protected void dispatchRecv(int length, byte[] buff) {
        this.mDispatchListener.recv(length, buff);
    }

    private class ConnectedThread
    extends DispatchThread {
        public ConnectedThread(Socket socket) {
            super(socket);
        }

        @Override
        public void execute() {
            LogUtil.i(this.TAG, "start run()");
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes = this.mInStream.read(buffer);
                    raSocketService.this.dispatchRecv(bytes, buffer);
                }
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "disconnected");
                raSocketService.this.connectionLost();
                raSocketService.this.start();
                return;
            }
        }
    }

    private class ConnectThread
    extends ClientThread {
        public ConnectThread(String address) {
            super(address);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            LogUtil.i(this.TAG, "start run()");
            try {
                this.mSocket.connect(new InetSocketAddress(this.mAddress, 12589), 0);
            }
            catch (IOException e) {
                try {
                    this.mSocket.close();
                }
                catch (IOException e2) {
                    LogUtil.e(this.TAG, "Exception during close", e2);
                }
                raSocketService.this.connectionFailed();
                return;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                raSocketService.this.mConnectThread = null;
            }
            raSocketService.this.connected(this.mSocket);
        }
    }

    private class AcceptThread
    extends ServerThread {
        private AcceptThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            Socket socket = null;
            while (raSocketService.this.mState != 3) {
                try {
                    socket = this.mServerSocket.accept();
                }
                catch (IOException e) {
                    LogUtil.e(this.TAG, "Exception during accept", e);
                    break;
                }
                if (socket != null) {
                    AcceptThread acceptThread = this;
                    synchronized (acceptThread) {
                        switch (raSocketService.this.mState) {
                            case 1: 
                            case 2: {
                                raSocketService.this.connected(socket);
                                break;
                            }
                            case 0: 
                            case 3: {
                                try {
                                    socket.close();
                                    break;
                                }
                                catch (IOException e) {
                                    LogUtil.e(this.TAG, "Exception during close", e);
                                }
                            }
                        }
                    }
                }
                LogUtil.i(this.TAG, "end run()");
            }
        }
    }
}

