/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.connect.socket;

import android.rapid.connect.socket.AbsThread;
import android.rapid.log.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class DispatchThread
extends AbsThread {
    protected final Socket mSocket;
    protected final InputStream mInStream;
    protected final OutputStream mOutStream;
    protected final LogUtil.Tag TAG = new LogUtil.Tag("DispatchThread");

    public DispatchThread(Socket socket) {
        this.mSocket = socket;
        InputStream tmpIn = null;
        OutputStream tmpOut = null;
        try {
            tmpIn = socket.getInputStream();
            tmpOut = socket.getOutputStream();
        }
        catch (IOException e) {
            LogUtil.e(this.TAG, "create Input/Output Stream failed");
        }
        this.mInStream = tmpIn;
        this.mOutStream = tmpOut;
        this.setName("DispatchThread");
    }

    public void recv(int length, byte[] bytes) {
    }

    @Override
    public void execute() {
        LogUtil.i(this.TAG, "start run()");
        byte[] buffer = new byte[1024];
        try {
            while (true) {
                int bytes = this.mInStream.read(buffer);
                this.recv(bytes, buffer);
            }
        }
        catch (IOException e) {
            LogUtil.e(this.TAG, "Exception during read", e);
            try {
                this.mSocket.close();
            }
            catch (Exception e1) {
                LogUtil.e(this.TAG, "Exception during close", e);
            }
            return;
        }
    }

    @Override
    public void cancel() {
        try {
            this.mSocket.close();
        }
        catch (IOException e) {
            LogUtil.e(this.TAG, "Exception during close", e);
        }
    }

    public void write(byte[] buffer) {
        try {
            this.mOutStream.write(buffer);
        }
        catch (IOException e) {
            LogUtil.e(this.TAG, "Exception during write", e);
        }
    }
}

