/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.connect.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.rapid.connect.AbsConnect;
import android.rapid.connect.ConnectDevice;
import android.rapid.connect.IAvailableDeviceListener;
import android.rapid.connect.bluetooth.BluetoothBroadcastReceiver;
import android.rapid.connect.bluetooth.BluetoothSocketService;
import java.util.ArrayList;
import java.util.List;

public class raBluetoothConnect
extends AbsConnect<BluetoothDevice> {
    private final BluetoothAdapter mAdapter;
    private final BluetoothManager mBluetoothManager;
    private Context mContext;
    private BluetoothSocketService mSocketService;
    private IAvailableDeviceListener mAvailableDeviceListener;
    private BluetoothBroadcastReceiver mReceiver;
    private List<ConnectDevice> mConnectDevices = new ArrayList<ConnectDevice>();
    private List<ConnectDevice> mNewDevices = new ArrayList<ConnectDevice>();

    public raBluetoothConnect(Context context, Handler handler) {
        this.mContext = context;
        this.mBluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mAdapter = this.mBluetoothManager.getAdapter();
        this.mSocketService = new BluetoothSocketService(this.mAdapter, handler);
        this.mReceiver = new BluetoothBroadcastReceiver(this);
        for (BluetoothDevice btdevice : this.mAdapter.getBondedDevices()) {
            ConnectDevice device = new ConnectDevice();
            device.device = btdevice;
            device.deviceName = btdevice.getName();
            device.status = btdevice.getBondState();
            device.connected = btdevice.getBondState() == 12;
            device.deviceStatus = this.getDeviceStatus(btdevice.getBondState());
            this.mConnectDevices.add(device);
        }
    }

    @Override
    public void enable() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.device.action.FOUND");
        this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, intentFilter);
        if (this.mAdapter.isEnabled()) {
            if (this.mSocketService.getState() == 0) {
                this.mSocketService.start();
            }
        } else {
            this.mAdapter.enable();
        }
    }

    @Override
    public void disable() {
        if (this.mAdapter != null) {
            this.mAdapter.cancelDiscovery();
        }
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mReceiver);
        this.mSocketService.stop();
    }

    @Override
    public void searchDevcie(IAvailableDeviceListener listener) {
        if (this.mAdapter.isDiscovering()) {
            this.mAdapter.startDiscovery();
        }
        this.mAdapter.startDiscovery();
        this.mAvailableDeviceListener = listener;
    }

    @Override
    public void connect(ConnectDevice<BluetoothDevice> device) {
        this.mSocketService.connect((BluetoothDevice)device.device);
    }

    @Override
    public void cancelConnect() {
        this.mSocketService.stop();
    }

    @Override
    public boolean isConnected() {
        return this.mSocketService.getState() == 3;
    }

    @Override
    public void send(byte[] data) {
        if (this.isConnected()) {
            this.mSocketService.write(data);
        }
    }

    @Override
    public List<ConnectDevice> getAvailableDevices() {
        return this.mConnectDevices;
    }

    private String getDeviceStatus(int deviceStatus) {
        switch (deviceStatus) {
            case 10: {
                return "NONE";
            }
            case 11: {
                return "BONDING";
            }
            case 12: {
                return "BONDED";
            }
        }
        return "Unknown";
    }

    public void addNewDevice(BluetoothDevice device) {
        ConnectDevice btdevice = new ConnectDevice();
        btdevice.device = device;
        btdevice.deviceName = device.getName();
        btdevice.status = device.getBondState();
        btdevice.deviceStatus = this.getDeviceStatus(device.getBondState());
        if (device.getBondState() != 12) {
            this.mNewDevices.add(btdevice);
        }
        if (this.mAvailableDeviceListener != null) {
            this.mAvailableDeviceListener.nextDevice(btdevice);
        }
    }
}

