/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.connect.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import android.rapid.connect.IDispatchListener;
import android.rapid.connect.socket.AbsThread;
import android.rapid.connect.socket.raSocketService;
import android.rapid.log.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

class BluetoothSocketService
extends raSocketService {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("BluetoothSocketService");
    private static final String NAME_INSECURE = "BluetoothSocketService";
    private static final UUID MY_UUID_INSECURE = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private final BluetoothAdapter mAdapter;

    public BluetoothSocketService(BluetoothAdapter adapter, Handler handler) {
        super(new BluetoothSocketDispatch(handler));
        this.mAdapter = adapter;
    }

    @Override
    public synchronized void start() {
        LogUtil.d(TAG, "start");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.setState(1);
        if (this.mAcceptThread == null) {
            this.mAcceptThread = new AcceptThread();
            this.mAcceptThread.start();
        }
    }

    public synchronized void connected(BluetoothSocket socket, BluetoothDevice device) {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mAcceptThread != null) {
            this.mAcceptThread.cancel();
            this.mAcceptThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.setState(3);
    }

    public synchronized void connect(BluetoothDevice device) {
        LogUtil.d(TAG, "connect to: " + device.getAddress());
        if (this.getState() == 2 && this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] out) {
        ConnectedThread r;
        BluetoothSocketService bluetoothSocketService = this;
        synchronized (bluetoothSocketService) {
            if (this.getState() != 3) {
                return;
            }
            r = (ConnectedThread)this.mConnectedThread;
        }
        r.write(out);
    }

    private class ConnectedThread
    extends AbsThread {
        private final LogUtil.Tag TAG = new LogUtil.Tag("ConnectedThread");
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(BluetoothSocket socket) {
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "create Input/Output Stream failed");
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
            this.setName("ConnectedThread");
        }

        @Override
        public void execute() {
            LogUtil.i(this.TAG, "start run()");
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes = this.mmInStream.read(buffer);
                    BluetoothSocketService.this.dispatchRecv(bytes, buffer);
                }
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "disconnected");
                BluetoothSocketService.this.connectionLost();
                BluetoothSocketService.this.start();
                return;
            }
        }

        public void write(byte[] buffer) {
            try {
                this.mmOutStream.write(buffer);
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "Exception during write", e);
            }
        }

        @Override
        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "Exception during close", e);
            }
        }
    }

    private class ConnectThread
    extends AbsThread {
        private final LogUtil.Tag TAG = new LogUtil.Tag("ConnectThread");
        private final BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;

        public ConnectThread(BluetoothDevice device) {
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(MY_UUID_INSECURE);
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "create() failed");
            }
            this.mmSocket = tmp;
            this.setName("ConnectThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            LogUtil.i(this.TAG, "start run()");
            BluetoothSocketService.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (IOException e) {
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    LogUtil.e(this.TAG, "close() socket failed");
                }
                BluetoothSocketService.this.connectionFailed();
                return;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                BluetoothSocketService.this.mConnectThread = null;
            }
            BluetoothSocketService.this.connected(this.mmSocket, this.mmDevice);
        }

        @Override
        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "close() of connect socket failed", e);
            }
        }
    }

    private class AcceptThread
    extends AbsThread {
        private final LogUtil.Tag TAG = new LogUtil.Tag("AcceptThread");
        private final BluetoothServerSocket mmServerSocket;

        public AcceptThread() {
            BluetoothServerSocket tmp = null;
            try {
                tmp = BluetoothSocketService.this.mAdapter.listenUsingRfcommWithServiceRecord(BluetoothSocketService.NAME_INSECURE, MY_UUID_INSECURE);
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "create() failed");
            }
            this.mmServerSocket = tmp;
            this.setName("AcceptThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            LogUtil.d(this.TAG, "start run()");
            BluetoothSocket socket = null;
            while (BluetoothSocketService.this.getState() != 3) {
                try {
                    socket = this.mmServerSocket.accept();
                }
                catch (IOException e) {
                    LogUtil.e(this.TAG, "accept() failed");
                    break;
                }
                if (socket != null) {
                    AcceptThread acceptThread = this;
                    synchronized (acceptThread) {
                        switch (BluetoothSocketService.this.getState()) {
                            case 1: 
                            case 2: {
                                BluetoothSocketService.this.connected(socket, socket.getRemoteDevice());
                                break;
                            }
                            case 0: 
                            case 3: {
                                try {
                                    socket.close();
                                    break;
                                }
                                catch (IOException e) {
                                    LogUtil.e(this.TAG, "close socket failed");
                                }
                            }
                        }
                    }
                }
                LogUtil.i(this.TAG, "end run()");
            }
        }

        @Override
        public void cancel() {
            LogUtil.d(this.TAG, "cancel()");
            try {
                this.mmServerSocket.close();
            }
            catch (IOException e) {
                LogUtil.e(this.TAG, "close() of server failed", e);
            }
        }
    }

    private static class BluetoothSocketDispatch
    implements IDispatchListener {
        private Handler mHandler;

        public BluetoothSocketDispatch(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void recv(int bytes, byte[] buffer) {
            this.mHandler.obtainMessage(2, bytes, -1, (Object)buffer).sendToTarget();
        }

        @Override
        public void connectionFailed() {
            this.mHandler.obtainMessage(3, -1, -1).sendToTarget();
        }

        @Override
        public void connectionLost() {
            this.mHandler.obtainMessage(3, -2, -1).sendToTarget();
        }
    }
}

