/*
 * Decompiled with CFR 0.152.
 */
package android.rapid.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

public class ViewHolder {
    private final SparseArray<View> mViews;
    private int mPosition;
    private View mConvertView;

    private ViewHolder(Context context, int position, ViewGroup parent, int layoutId) {
        this.mPosition = position;
        this.mViews = new SparseArray();
        this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        this.mConvertView.setTag((Object)this);
    }

    public static ViewHolder get(Context context, int position, View convertView, ViewGroup parent, int layoutId) {
        if (convertView == null) {
            return new ViewHolder(context, position, parent, layoutId);
        }
        return (ViewHolder)convertView.getTag();
    }

    public View getConvertView() {
        return this.mConvertView;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public <T extends View> T getView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public void setText(int viewId, String text) {
        TextView view = (TextView)this.getView(viewId);
        view.setText((CharSequence)text);
    }

    public void setImageResource(int viewId, int drawableId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(drawableId);
    }

    public void setImageBitmap(int viewId, Bitmap bm) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bm);
    }
}

