package android.rapid.view;

import android.app.Activity;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.rapid.log.LogUtil;
import android.view.View;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public final class raInjects {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("raInjects");

    private static void injectRes(InjectObj injectObj, Field field) throws Exception {
        raInjects.ResId outlet = field.getAnnotation(raInjects.ResId.class);
        if (null == outlet) {
            return;
        }
        int resId = outlet.id();
        Resources res = injectObj.getResources();
        String typeName = res.getResourceTypeName(resId);
        Object value = null;
        if ("string".equals(typeName)) {
            value = res.getString(resId);
        } else if ("drawable".equals(typeName)) {
            value = res.getDrawable(resId);
        } else if ("dimen".equals(typeName)) {
            value = res.getDimension(resId);
        } else if ("color".equals(typeName)) {
            Class<?> fieldType = field.getType();
            if (ColorStateList.class.isAssignableFrom(fieldType)) {
                value = res.getColorStateList(resId);
            } else {
                value = res.getColor(resId);
            }
        } else if ("array".equals(typeName)) {
            Class<?> fieldType = field.getType();
            if (String[].class.isAssignableFrom(fieldType)) {
                value = res.getStringArray(resId);
            } else if (int[].class.isAssignableFrom(fieldType)) {
                value = res.getIntArray(resId);
            }
        }
        field.set(injectObj.getObject(), value);
    }

    private static void injectView(InjectObj injectObj, Field field) throws Exception {
        raInjects.ViewId outlet = field.getAnnotation(raInjects.ViewId.class);
        if (null == outlet) {
            return;
        }
        int viewId = outlet.id();
        View view = injectObj.injectView(viewId);
        field.set(injectObj.getObject(), view);
    }

    private static void inject(InjectObj injectObj) {
        Field[] fields = injectObj.getObject().getClass().getDeclaredFields();
        for (Field field : fields) {
            boolean f = field.isAccessible();
            field.setAccessible(true);
            try {
                injectView(injectObj, field);
                injectRes(injectObj, field);
            } catch (Exception e) {
                LogUtil.e(TAG, "inject", e);
            } finally {
                field.setAccessible(f);
            }
        }
    }

    public static void inject(View view) {
        inject(new ViewInject(view));
    }

    public static void inject(Object obj, View view) {
        inject(new ViewInject(obj, view));
    }

    public static void inject(Activity activity) {
        inject(new ActivityInject(activity));
    }

    public static void inject(Object obj, Activity activity) {
        inject(new ActivityInject(obj, activity));
    }

    @Target(ElementType.FIELD)
    @Retention(RetentionPolicy.RUNTIME)
    public @interface ResId {
        int id();
    }

    @Target(ElementType.FIELD)
    @Retention(RetentionPolicy.RUNTIME)
    public @interface ViewId {
        int id();
    }

    public interface InjectObj {
        Object getObject();

        Resources getResources();

        View injectView(int viewId);
    }
}
