package android.rapid.view;

import android.app.Activity;
import android.content.res.Resources;
import android.view.View;

final class ActivityInject implements raInjects.InjectObj {
    private Activity mActivity;
    private Object mObject;

    public ActivityInject(Activity activity) {
        mActivity = activity;
    }

    public ActivityInject(Object obj, Activity activity) {
        mObject = obj;
        mActivity = activity;
    }


    @Override
    public Object getObject() {
        if (mObject != null) {
            return mObject;
        }
        return mActivity;
    }

    @Override
    public Resources getResources() {
        return mActivity.getResources();
    }

    @Override
    public View injectView(int viewId) {
        return mActivity.findViewById(viewId);
    }
}
