package android.rapid.reflect;


import android.os.Build;
import android.rapid.log.LogUtil;
import android.util.ArrayMap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class raReflect {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("raReflect");
    private static Map<String, Class> mClassMap;
    private static Map<String, Method> mMethodMap;

    static {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            mClassMap = new ArrayMap<String, Class>();
            mMethodMap = new ArrayMap<String, Method>();
        } else {
            mClassMap = new HashMap<String, Class>();
            mMethodMap = new HashMap<String, Method>();
        }
    }

    public static Object newInstance(Class<?> clazz, Object[] params) throws Exception {
        if (params != null && params.length > 0) {
            Constructor<?> con = clazz.getConstructor(getParamsTypes(params));
            return con.newInstance(params);
        } else {
            Constructor<?> con = clazz.getConstructor();
            Object obj = con.newInstance();
            return obj;
        }
    }

    public static Object newInstance(Class<?> clazz, Class<?>[] paramsTypes, Object[] params) throws Exception {
        if (params != null && params.length > 0) {
            Constructor<?> con = clazz.getConstructor(paramsTypes);
            return con.newInstance(params);
        } else {
            Constructor<?> con = clazz.getConstructor();
            Object obj = con.newInstance();
            return obj;
        }
    }

    public static Object invoke(Object obj, String methodName, Object[] params) throws Exception {
        return invoke(obj.getClass(), obj, methodName, params);
    }

    private static Object invoke(Class<?> objClass, Object obj, String methodName, Object[] params) throws Exception {
        if (params == null || params.length == 0) {
            synchronized (mMethodMap) {
                Method method = mMethodMap.get(methodName);
                if (method == null) {
                    method = objClass.getMethod(methodName);
                    method.setAccessible(true);
                    mMethodMap.put(methodName, method);
                }
                return method.invoke(obj);
            }
        } else {
            synchronized (mMethodMap) {
                Class<?>[] clazzes = getParamsTypes(params);
                StringBuilder sb = new StringBuilder(objClass.getName());
                sb.append('#');
                sb.append(methodName);
                sb.append(getParamsTypesString(clazzes));
                sb.append("#bestmatch");
                String fullName = sb.toString();
                Method method = mMethodMap.get(fullName);
                if (method == null) {
                    method = objClass.getMethod(methodName, clazzes);
                    method.setAccessible(true);
                    mMethodMap.put(fullName, method);
                }
                return method.invoke(obj, params);
            }
        }
    }

    public static boolean setField(Object desObj, Class<?> desClass, String fieldName, Object value) {
        if (desObj == null || desClass == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        try {
            Field field = desClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(desObj, value);
            return true;
        } catch (Exception ignore) {
            LogUtil.e(TAG, "setField Exception", ignore);
        }
        return false;
    }

    public static boolean setField(Object desObj, String fieldName, Object value) {
        if (desObj == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> desClass = desObj.getClass();
        return setFieldStepwise(desObj, desClass, fieldName, value);
    }

    private static boolean setFieldStepwise(Object desObj, Class<?> rootClass, String fieldName, Object value) {
        Class<?> desClass = rootClass;
        while (desClass != null) {
            if (setField(desObj, desClass, fieldName, value)) {
                return true;
            } else {
                try {
                    desClass = desClass.getSuperclass();
                } catch (Exception e) {
                    desClass = null;
                }
            }
        }
        return false;
    }

    public static boolean setStaticField(String className, String fieldName, Object value) {
        if (className == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> objClass = mClassMap.get(className);
        if (objClass == null) {
            try {
                objClass = Class.forName(className);
                mClassMap.put(className, objClass);
            } catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("className not found");
            }
        }
        return setFieldStepwise(objClass, objClass, fieldName, value);
    }

    public static Object getField(Object desObj, Class<?> desClass, String fieldName) throws NoSuchFieldException {
        if (desObj == null || desClass == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        try {
            Field field = desClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(desObj);
        } catch (Exception ignore) {
            throw new NoSuchFieldException(fieldName);
        }
    }

    public static Object getField(Object desObj, String fieldName) throws NoSuchFieldException {
        if (desObj == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> desClass = desObj.getClass();
        return getFieldStepwise(desObj, desClass, fieldName);
    }

    private static Object getFieldStepwise(Object desObj, Class<?> rootClass, String fieldName) throws NoSuchFieldException {
        Class<?> desClass = rootClass;
        while (desClass != null) {
            try {
                return getField(desObj, desClass, fieldName);
            } catch (NoSuchFieldException ignore) {
            }
            try {
                desClass = desClass.getSuperclass();
            } catch (Exception e) {
                desClass = null;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static Object getStaticField(String className, String fieldName) throws NoSuchFieldException {
        if (className == null || fieldName == null) {
            throw new IllegalArgumentException("parameter can not be null!");
        }
        Class<?> objClass = mClassMap.get(className);
        if (objClass == null) {
            try {
                objClass = Class.forName(className);
                mClassMap.put(className, objClass);
            } catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("className not found");
            }
        }
        return getFieldStepwise(objClass, objClass, fieldName);
    }

    private static Class<?>[] getParamsTypes(Object[] params) {
        Class<?>[] paramsType = new Class[params.length];
        for (int i = 0; i < paramsType.length; ++i) {
            paramsType[i] = params[i].getClass();
        }
        return paramsType;
    }

    private static String getParamsTypesString(Class<?>... clazzes) {
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (Class<?> clazz : clazzes) {
            if (first)
                first = false;
            else
                sb.append(",");
            if (clazz != null)
                sb.append(clazz.getCanonicalName());
            else
                sb.append("null");
        }
        sb.append(")");
        return sb.toString();
    }
}
