package android.rapid.net;


import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;

import android.rapid.net.exception.NetworkException;

import java.util.HashMap;
import java.util.Map;

public class BasicNetwork implements Network {
    private IHttpClient mHttpClient;

    public BasicNetwork(IHttpClient httpClient) {
        mHttpClient = httpClient;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) throws NetworkException {
        while (true) {
            HttpResponse httpResponse = null;
            byte[] responseContents = null;
            try {
                Map<String, String> headers = new HashMap<>();
                httpResponse = mHttpClient.performRequest(request, headers);
                StatusLine statusLine = httpResponse.getStatusLine();
                int statusCode = statusLine.getStatusCode();
                if (httpResponse.getEntity() != null) {
                    responseContents = EntityUtils.toByteArray(httpResponse.getEntity());
                } else {
                    responseContents = new byte[0];
                }
                return new NetworkResponse(statusCode, responseContents);
            } catch (Exception e) {
                throw new NetworkException(e);
            }
        }
    }
}
