package android.rapid.connect.socket;

import android.rapid.log.LogUtil;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class ServerThread extends AbsThread {
    protected final ServerSocket mServerSocket;
    protected final LogUtil.Tag TAG = new LogUtil.Tag("ServerThread");
    private final int THREAD_COUNT = 10;
    private final ThreadPoolExecutor mPool = new ThreadPoolExecutor(
            THREAD_COUNT, THREAD_COUNT, 10, TimeUnit.SECONDS,
            new LinkedBlockingQueue<Runnable>());

    public ServerThread() {
        ServerSocket tmp = null;
        try {
            tmp = new ServerSocket(mServerPort);
        } catch (IOException e) {
            LogUtil.e(TAG, "Create ServerSocket failed");
        }
        mServerSocket = tmp;
        setName("ServerThread");
    }

    @Override
    public void execute() {
        LogUtil.d(TAG, "start run()");
        Socket socket = null;

        while (true) {
            try {
                socket = mServerSocket.accept();
                mPool.execute(new DispatchThread(socket));
            } catch (Exception e) {
                LogUtil.e(TAG, "accept() failed");
                break;
            }
        }
    }

    @Override
    public void cancel() {

    }
}
