package android.rapid.connect.socket;


import android.rapid.log.LogUtil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class DispatchThread extends AbsThread {
    protected final Socket mSocket;
    protected final InputStream mInStream;
    protected final OutputStream mOutStream;
    protected final LogUtil.Tag TAG = new LogUtil.Tag("DispatchThread");

    public DispatchThread(Socket socket) {
        mSocket = socket;
        InputStream tmpIn = null;
        OutputStream tmpOut = null;

        try {
            tmpIn = socket.getInputStream();
            tmpOut = socket.getOutputStream();
        } catch (IOException e) {
            LogUtil.e(TAG, "create Input/Output Stream failed");
        }

        mInStream = tmpIn;
        mOutStream = tmpOut;
        setName("DispatchThread");
    }

    public void recv(int length, byte[] bytes) {
    }

    @Override
    public void execute() {
        LogUtil.i(TAG, "start run()");
        byte[] buffer = new byte[1024];
        int bytes;

        while (true) {
            try {
                bytes = mInStream.read(buffer);
                recv(bytes, buffer);
            } catch (IOException e) {
                LogUtil.e(TAG, "Exception during read", e);
                try {
                    mSocket.close();
                } catch (Exception e1) {
                    LogUtil.e(TAG, "Exception during close", e);
                }
                break;
            }
        }
    }

    @Override
    public void cancel() {
        try {
            mSocket.close();
        } catch (IOException e) {
            LogUtil.e(TAG, "Exception during close", e);
        }
    }

    public void write(byte[] buffer) {
        try {
            mOutStream.write(buffer);
        } catch (IOException e) {
            LogUtil.e(TAG, "Exception during write", e);
        }
    }
}
