package android.rapid.connect.socket;


import android.rapid.log.LogUtil;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

class ClientThread extends AbsThread {
    protected final Socket mSocket;
    protected final String mAddress;
    protected final LogUtil.Tag TAG = new LogUtil.Tag("ClientThread");

    public ClientThread(String address) {
        mAddress = address;
        Socket tmp = null;
        try {
            tmp = new Socket();
            tmp.bind(null);
        } catch (IOException e) {
            LogUtil.e(TAG, "create Socket failed");
        }
        mSocket = tmp;
        setName("ClientThread");
    }

    @Override
    public void execute() {
        LogUtil.i(TAG, "start run()");

        try {
            mSocket.connect((new InetSocketAddress(mAddress, mServerPort)), 0);
            new DispatchThread(mSocket).start();
        } catch (IOException e) {
            try {
                mSocket.close();
            } catch (IOException e2) {
                LogUtil.e(TAG, "Exception during close", e2);
            }
        }

    }

    @Override
    public void cancel() {
        try {
            mSocket.close();
        } catch (IOException e) {
            LogUtil.e(TAG, "Exception during close", e);
        }
    }
}
