package android.rapid.view;

import android.content.res.Resources;
import android.view.View;

final class ViewInject implements raInjects.InjectObj {
    private View mView;
    private Object mObject;

    public ViewInject(View view) {
        mView = view;
    }

    public ViewInject(Object obj, View view) {
        mObject = obj;
        mView = view;
    }

    @Override
    public Object getObject() {
        if (mObject != null) {
            return mObject;
        }
        return mView;
    }

    @Override
    public Resources getResources() {
        return mView.getResources();
    }

    @Override
    public View injectView(int viewId) {
        return mView.findViewById(viewId);
    }
}
