package android.rapid.net.request;


import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

import android.rapid.net.NetworkResponse;
import android.rapid.net.Request;
import android.rapid.net.Response;
import android.rapid.net.exception.ParseError;

import java.io.StringReader;

public class XMLRequest extends Request<XmlPullParser> {
    public XMLRequest(String url) {
        super(url);
    }

    @Override
    protected Response<XmlPullParser> parseNetworkResponse(NetworkResponse response) throws ParseError {
        try {
            String xmlString = new String(response.data, getParamsEncoding());
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser xmlPullParser = factory.newPullParser();
            xmlPullParser.setInput(new StringReader(xmlString));
            return Response.build(xmlPullParser);
        } catch (Exception e) {
            throw new ParseError(e);
        }
    }
}
