package android.rapid.net.request;

import android.rapid.net.NetworkResponse;
import android.rapid.net.Request;
import android.rapid.net.Response;
import android.rapid.net.exception.ParseError;

public class StringRequest extends Request<String> {

    public StringRequest(int method, String url) {
        super(method, url);
    }

    public StringRequest(String url) {
        this(Method.GET, url);
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) throws ParseError {
        try {
            String parsed = new String(response.data, getParamsEncoding());
            return Response.build(parsed);
        } catch (Exception e) {
            throw new ParseError(e);
        }
    }
}
