package android.rapid.net.request;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.rapid.net.NetworkResponse;
import android.rapid.net.Request;
import android.rapid.net.Response;
import android.rapid.net.exception.ParseError;


public class ImageRequest extends Request<Bitmap> {
    public ImageRequest(String url) {
        super(url);
    }

    @Override
    protected Response<Bitmap> parseNetworkResponse(NetworkResponse response) throws ParseError {
        byte[] data = response.data;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        Bitmap bitmap = null;
        decodeOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray(data, 0, data.length, decodeOptions);
        decodeOptions.inJustDecodeBounds = false;
        Bitmap tempBitmap =
                BitmapFactory.decodeByteArray(data, 0, data.length, decodeOptions);
        bitmap = tempBitmap;
        return Response.build(bitmap);
    }
}
