package android.rapid.net;

import android.graphics.Bitmap;
import android.net.http.AndroidHttpClient;
import android.os.Build;
import android.rapid.net.request.ImageRequest;
import android.rapid.task.raAsyncTask;
import android.widget.ImageView;

public class raNetAsyncTask {
    private static raNetAsyncTask mInst;
    private IHttpClient mHttpClient;
    private String mUserAgent = "raNetAsyncTask/v1";

    public void setUserAgent(String userAgent) {
        mUserAgent = userAgent;
    }

    private raNetAsyncTask() {
        if (mHttpClient == null) {
            if (Build.VERSION.SDK_INT >= 9) {
                mHttpClient = new HttpClientV1();
            } else {
                mHttpClient = new HttpClientV2(AndroidHttpClient.newInstance(mUserAgent));
            }
        }
    }

    public static raNetAsyncTask newNetTask() {
        if (mInst == null) {
            mInst = new raNetAsyncTask();
        }
        return mInst;
    }

    public static void loadBitmap(String url, final ImageView imageView) {
        newNetTask().request(new ImageRequest(url)).subscibe(new raAsyncTask.raResult<Response<Bitmap>>() {
            @Override
            public void onCancelled(Response<Bitmap> t) {
            }

            @Override
            public void onError(Throwable e) {
            }

            @Override
            public void onResult(Response<Bitmap> t) {
                imageView.setImageBitmap(t.result);
            }
        });
    }

    public <T> raAsyncTask<Request<T>, Response<T>> request(Request<T> request) {
        return raAsyncTask.createTask(new raAsyncTask.raTask<Request<T>, Response<T>>() {
            @Override
            public Response<T> execute(Request<T> request) throws Exception {
                BasicNetwork network = new BasicNetwork(mHttpClient);
                NetworkResponse response = network.performRequest(request);
                return request.parseNetworkResponse(response);
            }
        }, request);
    }
}
