package android.rapid.connect.wifi;

import android.os.Handler;
import android.rapid.connect.IDispatchListener;
import android.rapid.connect.socket.raSocketService;
import android.rapid.log.LogUtil;

class WifiSocketService extends raSocketService {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("WifiSocketService");


    public WifiSocketService(Handler handler) {
        super(new WifiSocketDispatch(handler));
    }

    private static class WifiSocketDispatch implements IDispatchListener {
        private Handler mHandler;

        public WifiSocketDispatch(Handler handler) {
            mHandler = handler;
        }

        public void recv(int bytes, byte[] buffer) {
            mHandler.obtainMessage(raWifiConnect.MESSAGE_RECV, bytes, -1, buffer).sendToTarget();
        }

        @Override
        public void connectionFailed() {
            mHandler.obtainMessage(raWifiConnect.MESSAGE_CONNECT_STATE, -1, -1).sendToTarget();
        }

        @Override
        public void connectionLost() {
            mHandler.obtainMessage(raWifiConnect.MESSAGE_CONNECT_STATE, -2, -1).sendToTarget();
        }
    }
}
