package android.rapid.connect.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pManager;

class WiFiDirectBroadcastReceiver extends BroadcastReceiver {
    private raWifiConnect mWifiConnect;

    public WiFiDirectBroadcastReceiver(raWifiConnect wifiConnect) {
        mWifiConnect = wifiConnect;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (WifiP2pManager.WIFI_P2P_STATE_CHANGED_ACTION.equals(action)) {
            int state = intent.getIntExtra(WifiP2pManager.EXTRA_WIFI_STATE, -1);
            if (state == WifiP2pManager.WIFI_P2P_STATE_ENABLED) {
                mWifiConnect.discoverPeers();
            } else {
                mWifiConnect.resetPeers();
            }
        } else if (WifiP2pManager.WIFI_P2P_PEERS_CHANGED_ACTION.equals(action)) {
            if (mWifiConnect.isWifiP2pAviliable()) {
                mWifiConnect.requestPeers();
            }
        } else if (WifiP2pManager.WIFI_P2P_CONNECTION_CHANGED_ACTION.equals(action)) {
            if (!mWifiConnect.isWifiP2pAviliable()) {
                return;
            }
            NetworkInfo networkInfo = intent.getParcelableExtra(WifiP2pManager.EXTRA_NETWORK_INFO);
            if (networkInfo.isConnected()) {
                mWifiConnect.requestConnectionInfo();
            } else {
                mWifiConnect.resetPeers();
                mWifiConnect.discoverPeers();
            }
        } else if (WifiP2pManager.WIFI_P2P_THIS_DEVICE_CHANGED_ACTION.equals(action)) {
            WifiP2pDevice wifiP2pDevice = intent.getParcelableExtra(WifiP2pManager.EXTRA_WIFI_P2P_DEVICE);
            mWifiConnect.updateThisDevice(wifiP2pDevice);
        }
    }
}
