package android.rapid.connect.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

class BluetoothBroadcastReceiver extends BroadcastReceiver {
    private raBluetoothConnect mBluetoothConnect;

    public BluetoothBroadcastReceiver(raBluetoothConnect bluetoothConnect) {
        mBluetoothConnect = bluetoothConnect;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (BluetoothDevice.ACTION_FOUND.equals(action)) {
            BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);
            mBluetoothConnect.addNewDevice(device);
        }
    }
}
