package android.rapid.connect;

import java.util.List;

public abstract class AbsConnect<T> {
    public static final int MESSAGE_RECV = 2;
    public static final int MESSAGE_CONNECT_STATE = 3;

    public abstract void enable();

    public abstract void disable();

    public abstract void searchDevcie(IAvailableDeviceListener listener);

    public abstract void connect(ConnectDevice<T> device);

    public abstract void cancelConnect();

    public abstract boolean isConnected();

    public abstract void send(byte[] data);

    public abstract List<ConnectDevice> getAvailableDevices();
}
