package android.rapid.database;

import android.database.Cursor;
import android.rapid.log.LogUtil;

import java.lang.reflect.Field;

public class CursorInject {
    private static final LogUtil.Tag TAG = new LogUtil.Tag("CursorInject");

    public static void inject(Cursor c, Object obj) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    ICursorId outlet = field.getAnnotation(ICursorId.class);
                    if (outlet != null) {
                        field.set(obj, c.getString(c.getColumnIndex(outlet.id())));
                    }
                }
            }
        } catch (Exception e) {
            LogUtil.e(TAG, "inject exception");
        } finally {
            if (c != null) {
                c.close();
            }
        }
    }
}
