package android.rapid.activity;

import android.app.Activity;
import android.util.Log;

import java.lang.reflect.Field;

public class RapidActivity {

    public static void inject(Activity activity) {
        Field[] fields = activity.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    if (field.get(activity) != null) {
                        continue;
                    }
                    IViewId outlet = field.getAnnotation(IViewId.class);
                    if (outlet != null) {
                        int viewId = outlet.id();
                        field.set(activity, activity.findViewById(viewId));
                    }
                } catch (Exception e) {
                    Log.e("RapidActivity", "registerViewEvent exception");
                }
            }
        }
    }
}
