package android.rapid.view;

import android.util.Log;
import android.view.View;

import java.lang.reflect.Field;

public class ViewInject {
    private static final String TAG = "ViewInject";

    public static void inject(Object obj, View view) {
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                try {
                    field.setAccessible(true);
                    if (field.get(obj) != null) {
                        continue;
                    }
                    IViewId outlet = field.getAnnotation(IViewId.class);
                    if (outlet != null) {
                        int viewId = outlet.id();
                        field.set(obj, view.findViewById(viewId));
                    }
                } catch (Exception e) {
                    Log.e(TAG, "inject exception");
                }
            }
        }
    }
}
