package android.rapid.database;

import android.database.Cursor;
import android.util.Log;

import java.lang.reflect.Field;

public class CursorInject {
    private static final String TAG = "RapidCursor";

    public static void inject(Cursor c, Object obj) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    field.setAccessible(true);
                    ICursorId outlet = field.getAnnotation(ICursorId.class);
                    if (outlet != null) {
                        field.set(obj, c.getString(c.getColumnIndex(outlet.id())));
                    }
                }
            }
        } catch (Exception e) {
            Log.e(TAG, "RapidCursor.inject exception");
        } finally {
            if (c != null) {
                c.close();
            }
        }
    }
}
