package android.pixnet.net.ad_sdk.view;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.pixnet.net.ad_sdk.PixnetAd;
import android.pixnet.net.ad_sdk.download.PixnetADDownloadDataCallback;
import android.pixnet.net.ad_sdk.download.PixnetAdDownloadTask;
import android.pixnet.net.ad_sdk.modle.PixnetAdData;
import android.pixnet.net.ad_sdk.modle.PixnetAdItem;
import android.pixnet.net.ad_sdk.util.ErrorLog;
import android.pixnet.net.ad_sdk.util.Helper;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.android.volley.toolbox.NetworkImageView;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;


/**
 * Created by abreu on 15/8/11.
 * Copyright (c) 2015, p42106@gmail.com All Rights Reserved.
 */
public class PixnetBannerAdView extends LinearLayout {
    private Context context;
    private NetworkImageView networkImageView;
    private PixnetAdItem item;
    private Handler handler = new Handler();
    private String sizeType;
    private PixnetAd.AdListener adListener;

    private Runnable imageRunnable = new Runnable() {
        @Override
        public void run() {
            setBackgroundColor(0X60FFFFFF);
            networkImageView.setScaleType(ImageView.ScaleType.FIT_XY);
            networkImageView.setImageUrl("http:" + item.file, Helper.getImageLoader(Helper.getRequestQueueNoCookie(context)));
        }
    };
    private AdView adView;
    private Runnable adRunnable = new Runnable() {
        @Override
        public void run() {

            AdRequest adRequest;
            if (PixnetAd.isTestMode()) {
                String android_id = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
                String deviceId = PixnetAd.md5(android_id).toUpperCase();
                adRequest = new AdRequest.Builder().addTestDevice(deviceId).build();
            } else {
                adRequest = new AdRequest.Builder().build();
            }
            // 以廣告請求載入 adView。
            adView.loadAd(adRequest);


        }
    };
    private int showTime = 0;

    public PixnetBannerAdView(Context context) {

        this(context, null);

    }


    public PixnetBannerAdView(Context context, AttributeSet attrs) {

        this(context, attrs, 0);

    }

    public PixnetBannerAdView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setLayoutParams(new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        this.context = context;
    }


    public PixnetBannerAdView setSize(String sizeType) {
        this.sizeType = sizeType;
        return this;
    }

    public PixnetBannerAdView setUnitid(String id) {
        PixnetAd.setUnitid(id);
        return this;
    }

    //載入廣告
    public void loadAd() {
        if (null == PixnetAd.getUnitid()) {
            ErrorLog.noID(context.getClass().toString());
            return;
        }

        if (null == sizeType) {
            ErrorLog.noSize(context.getClass().toString());
            return;
        }

        if (sizeType.equals(PixnetAd.BANNER) || sizeType.equals(PixnetAd.FULL_BANNER) || sizeType.equals(PixnetAd.LARGE_BANNER) || sizeType.equals(PixnetAd.LEADERBOARD) || sizeType.equals(PixnetAd.MEDIUM_RECTANGLE)) {
            Log.v("PIXNET AD", "Size Type is " + sizeType.substring(0, 3) + "*" + sizeType.replace("i", "").substring(4));
        } else {
            ErrorLog.noSize(context.getClass().toString());
            return;

        }
        networkImageView = new NetworkImageView(context);

        addView(networkImageView);
//        addAdBanner();
        new PixnetAdDownloadTask().getInstance().getPixnetBannerADData(context, new PixnetADDownloadDataCallback() {
            @Override
            public void serverRequest_Callback(Object object) {
                if (object instanceof PixnetAdData) {
                    PixnetAdData data = (PixnetAdData) object;
                    if (null != data.ad_slots && null != data.ad_slots.get(0).ad_list && data.ad_slots.get(0).ad_list.size() > 0) {
                        item = data.ad_slots.get(0).ad_list.get(0);

                        DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
                        float height, width;
                        int dbHight, dbWidth;
                        dbWidth = Integer.valueOf(sizeType.substring(0, 3));
                        dbHight = Integer.valueOf(sizeType.substring(4));
                        //橫幅高寬設定
//                        if (displayMetrics.heightPixels > displayMetrics.widthPixels) {
                        //直屏
                        height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dbHight, displayMetrics);
                        width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dbWidth, displayMetrics);
//                        } else {
//                            //橫屏
//                            height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 50, displayMetrics);
//                            width = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 320, displayMetrics);
//                        }

                        networkImageView.setPadding(0, 5, 0, 5);
                        networkImageView.setLayoutParams(new LinearLayout.LayoutParams((int) width, (int) height));


                        handler.postDelayed(imageRunnable, 500);


                        networkImageView.setOnClickListener(new OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                if (null!=adListener){
                                    adListener.onAdOpen();
                                }
                                Intent ie = new Intent(Intent.ACTION_VIEW, Uri.parse("http:" + item.click_url));
                                context.startActivity(ie);
                            }
                        });
                        if (null!=adListener){
                            adListener.onAdLoaded();
                        }
                        return;
                    }
                }
                addAdBanner();

            }
        }, sizeType);
    }


//    public PixnetBannerAdView setShowTime(int showTime) {
//        this.showTime = showTime;
//        return this;
//    }

    public void pause() {

        handler.removeCallbacks(imageRunnable);
        if (adView != null) {
            adView.pause();
        }

    }

    public void resume() {
        if (adView != null) {
            adView.resume();
        }
    }

    public void destroy() {
        handler.removeCallbacks(imageRunnable);
        handler.removeCallbacks(adRunnable);
        if (adView != null) {
            adView.destroy();
        }
    }

    //加入ADmob
    private void addAdBanner() {
        adView = new AdView(context);

        adView.setAdUnitId(PixnetAd.AD_ID);


        switch (sizeType) {
            case PixnetAd.BANNER:
                adView.setAdSize(AdSize.BANNER);
                break;
            case PixnetAd.FULL_BANNER:
                adView.setAdSize(AdSize.FULL_BANNER);
                break;
            case PixnetAd.LARGE_BANNER:
                adView.setAdSize(AdSize.LARGE_BANNER);
                break;
            case PixnetAd.LEADERBOARD:
                adView.setAdSize(AdSize.LEADERBOARD);
                break;
            case PixnetAd.MEDIUM_RECTANGLE:
                adView.setAdSize(AdSize.MEDIUM_RECTANGLE);
                break;
            default:
                adView.setAdSize(AdSize.SMART_BANNER);
                break;
        }
        //設定banner高度
        DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
        float height;
        int dbHight;
        dbHight = Integer.valueOf(sizeType.substring(4));
        height = TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dbHight, displayMetrics);
        adView.setAdListener(new AdListener() {
            @Override
            public void onAdClosed() {

                super.onAdClosed();
                if (null!=adListener){
                    adListener.onAdClosed();
                }
            }

            @Override
            public void onAdFailedToLoad(int errorCode) {
                Log.e("PIXNET AD", "Banner onAdFailedToLoad  :  " + getErrorMessage(errorCode));
                super.onAdFailedToLoad(errorCode);
                if (null!=adListener){
                    adListener.onAdFailedToLoad(getErrorMessage(errorCode));
                }
            }



            @Override
            public void onAdLoaded() {

                super.onAdLoaded();
                if (null!=adListener){
                    adListener.onAdLoaded();
                }
            }

            @Override
            public void onAdOpened() {
                super.onAdOpened();
            }
        });
        adView.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (int) height));
        addView(adView);


        // 以廣告請求載入 adView。

        handler.postDelayed(adRunnable, 500);

    }


    public void setAdListener(PixnetAd.AdListener adListener) {

        this.adListener = adListener;

    }
//    private String getBannerTag() {
//        return getResources().getDisplayMetrics().heightPixels > getResources().getDisplayMetrics().widthPixels ? "H" : "W";
//    }
private static String getErrorMessage(int errorCode) {
    switch (errorCode) {
        case 0:
            return "Something happened internally; for instance, the Activity may have been destroyed mid-refresh.";

        case 1:
            return "The ad request is invalid.";

        case 2:
            return "The ad request was unsuccessful due to network connectivity.";

        case 3:
            return "The ad request is successful, but no ad was returned due to lack of ad inventory.";

        default:
            return "Other error.";
    }

}

}
