package android.pixnet.net.ad_sdk.util;

import android.graphics.Bitmap;
import android.util.LruCache;

import com.android.volley.toolbox.ImageLoader.ImageCache;

public class ClearableImageCache implements ImageCache {

    private LruCache<String, Bitmap> cache = new LruCache<String, Bitmap>(5 * 1024 * 1024) {
        @Override
        protected int sizeOf(String key, Bitmap value) {
            return value.getByteCount();
        }
    };

    @Override
    public void putBitmap(String url, Bitmap bitmap) {
        cache.put(url, bitmap);
    }

    @Override
    public Bitmap getBitmap(String url) {

        return cache.get(url);
    }

    public void clear() {
        cache.evictAll();
    }

}
