package android.pixnet.net.ad_sdk.download;


import android.content.Context;
import android.os.Build;
import android.pixnet.net.ad_sdk.PixnetAd;
import android.pixnet.net.ad_sdk.modle.PixnetAdData;

public class PixnetAdDownloadTask {

    private PixnetAdDownloadTask instance = null;

    //手機id
    private String androidId = Build.SERIAL;
    //手機廠牌
    private String brand = Build.BRAND;
    // 設備名稱
    private String device = Build.DEVICE;

    private String unitID = PixnetAd.getUnitid() + makeRandom(10);

    private String packageName;

    private Context context;

    private static int makeRandom(int size) {
        return (int) (Math.random() * size);
    }

    public PixnetAdDownloadTask getInstance() {


        if (instance == null) {
            instance = new PixnetAdDownloadTask();
        }
        return instance;
    }

    //Pixnet全版廣告
    public void getPixnetADData(Context context, PixnetADDownloadDataCallback dataCallback, String sizeType) {
        this.context = context;
//        StringBuffer Api = new StringBuffer("https://falcon.pixanalytics.com/ad/json/1141?version=2");


//        new PixnetADSendDataUtil(context,Api.toString(), dataCallback, PixnetADData.class, true);
        new NewPixnetADSendDataUtil(context, makeURL(sizeType), dataCallback, PixnetAdData.class, true, sizeType);

    }

    //Pixnet 廣告資料(可用於listitem)
    public void getPixnetADListData(Context context, PixnetADDownloadDataCallback dataCallback) {
        this.context = context;


        new NewPixnetADSendDataUtil(context, makeURL(PixnetAd.NATIVE), dataCallback, PixnetAdData.class, false, null);

    }

    //Pixnet Banner廣告
    public void getPixnetBannerADData(Context context, PixnetADDownloadDataCallback dataCallback, String sizeType) {
        this.context = context;


        new NewPixnetADSendDataUtil(context, makeURL(sizeType), dataCallback, PixnetAdData.class, false, sizeType);

    }

    private String makeURL(String sizeType) {
        packageName = context.getPackageName();
        StringBuffer api = new StringBuffer("https://falcon.pixanalytics.com/ad/app");
        api.append("?publisherid=" + unitID);
        api.append("&size=" + sizeType);
        api.append("&device=" + brand + '_' + device);
        api.append("&uuid=" + androidId);
        api.append("&package=" + packageName);
        return api.toString();
    }
}
