package android.pixnet.net.ad_sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.pixnet.net.ad_sdk.download.PixnetADDownloadDataCallback;
import android.pixnet.net.ad_sdk.download.PixnetAdDownloadTask;
import android.pixnet.net.ad_sdk.modle.PixnetAdData;
import android.pixnet.net.ad_sdk.modle.PixnetAdItem;
import android.pixnet.net.ad_sdk.modle.PixnetAdSlot;
import android.pixnet.net.ad_sdk.util.ErrorLog;
import android.pixnet.net.ad_sdk.util.Helper;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.android.volley.toolbox.NetworkImageView;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by abreu on 15/8/10.
 * Copyright (c) 2015, p42106@gmail.com All Rights Reserved.
 */
public class PixnetAd {

    public static final String BANNER = "320x50", LARGE_BANNER = "320x100", MEDIUM_RECTANGLE = "300x250",
            FULL_BANNER = "468x60", LEADERBOARD = "728x90", INTERSTITIAL = "320x480i", COVER = "300x250i", NATIVE = "100x100n";

    static PixnetAd instance;
    private static List<PixnetAdItem> bannerList = new ArrayList<>();
    //    private static List<String> saveDialogList;
    private static PixnetAdSlot interstitialAdSlot;
    private static GetADData myGetBannerItem;
    private static InterstitialAd mInterstitialAd;
    private static String id;
    private static AdListener adListener;
    private static String sizeType;
    private static Dialog adDialog;
    private static boolean isTest = false;
    public static final String AD_ID = "ca-app-pub-3940256099942544/4411468910";

    static {
        getInstance();
    }

    private static void getInstance() {

        if (instance == null) {
            instance = new PixnetAd();
        }

    }


    //插頁廣告
    public static void showAdDialog(final Context context) {
        if (null == PixnetAd.getUnitid()) {
            ErrorLog.noID(context.getClass().toString());
            return;
        }
        if (null == sizeType) {
            ErrorLog.noSize(context.getClass().toString());
            return;
        }
        if (sizeType.equals(PixnetAd.INTERSTITIAL) || sizeType.equals(PixnetAd.COVER)) {
            Log.v("PIXNET AD", "Size Type is " + sizeType.substring(0, 3) + "*" + sizeType.replace("i", "").substring(4));
        } else {
            ErrorLog.noSize(context.getClass().toString());
            return;
        }

//        saveDialogList = new ArrayList<>();


        new PixnetAdDownloadTask().getInstance().getPixnetADData(context, new PixnetADDownloadDataCallback() {
            @TargetApi(Build.VERSION_CODES.HONEYCOMB)
            @Override
            public void serverRequest_Callback(Object object) {
                PixnetAdData data = (PixnetAdData) object;
                if (null != data && null != data.ad_slots && data.ad_slots.size() > 0 && null != data.ad_slots.get(0).ad_list && data.ad_slots.get(0).ad_list.size() > 0) {
                    if (null != adListener) {
                        adListener.onAdLoaded();

                    }
//                    final PixnetAdItem item = data.ad_slots.get(0).ad_list.get(0);
                    if (!((Activity) context).isFinishing()) {

                        instance.makeDialog(data.ad_slots.get(0), context).show();
                        if (null != adListener) {
                            adListener.onAdOpen();
                        }
                    }


                } else {

                    mInterstitialAd = new InterstitialAd(context);
                    mInterstitialAd.setAdUnitId(AD_ID);
                    AdRequest adRequest;
                    if (isTest) {
                        String android_id = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
                        String deviceId = md5(android_id).toUpperCase();
                        adRequest = new AdRequest.Builder().addTestDevice(deviceId).build();
                    } else {
                        adRequest = new AdRequest.Builder().build();
                    }

                    mInterstitialAd.loadAd(adRequest);
                    mInterstitialAd.setAdListener(new com.google.android.gms.ads.AdListener() {
                        @Override
                        public void onAdClosed() {
                            if (null != adListener) {
                                adListener.onAdClosed();
                            }
                        }

                        @Override
                        public void onAdOpened() {
                            if (null != adListener) {
                                adListener.onAdOpen();
                            }

                        }

                        @Override
                        public void onAdLoaded() {

                            mInterstitialAd.show();
                        }

                        @Override
                        public void onAdFailedToLoad(int errorCode) {
                            Log.e("PIXNET AD", "==============================onAdFailedToLoad  " + getErrorMessage(errorCode));
                            if (null != adListener) {
                                adListener.onAdFailedToLoad();
                            }
                        }
                    });
                }
            }
        }, sizeType);

    }

    //插頁廣告-預備用
    public static void showAdInterstitial(final Context context) {
        if (null == PixnetAd.getUnitid()) {
            ErrorLog.noID(context.getClass().toString());
            return;
        }
        if (null == sizeType) {
            ErrorLog.noSize(context.getClass().toString());
            return;
        }
        if (sizeType.equals(PixnetAd.INTERSTITIAL) || sizeType.equals(PixnetAd.COVER)) {
            Log.v("PIXNET AD", "Size Type is " + sizeType.substring(0, 3) + "*" + sizeType.replace("i", "").substring(4));
        } else {
            ErrorLog.noSize(context.getClass().toString());
            return;
        }

        if (null != interstitialAdSlot && !((Activity) context).isFinishing()) {

            instance.makeDialog(interstitialAdSlot, context).show();
            if (null != adListener) {
                adListener.onAdOpen();
            }
        } else if (null != mInterstitialAd && mInterstitialAd.isLoaded()) {

            mInterstitialAd.show();
        }
    }

    //預載插入廣告
    public static void loadAdInterstitial(final Context context) {
        if (null == PixnetAd.getUnitid()) {
            ErrorLog.noID(context.getClass().toString());
            return;
        }
        if (sizeType.equals(PixnetAd.INTERSTITIAL) || sizeType.equals(PixnetAd.COVER)) {
            Log.v("PIXNET AD", "Size Type is " + sizeType.substring(0, 3) + "*" + sizeType.replace("i", "").substring(4));
        } else {
            ErrorLog.noSize(context.getClass().toString());
            return;

        }
        interstitialAdSlot = null;
        mInterstitialAd = null;
        new PixnetAdDownloadTask().getInstance().getPixnetADData(context, new PixnetADDownloadDataCallback() {
            @TargetApi(Build.VERSION_CODES.HONEYCOMB)
            @Override
            public void serverRequest_Callback(Object object) {
                PixnetAdData data = (PixnetAdData) object;
                if (null != data && null != data.ad_slots && data.ad_slots.size() > 0 && null != data.ad_slots.get(0).ad_list && data.ad_slots.get(0).ad_list.size() > 0) {

                    interstitialAdSlot = data.ad_slots.get(0);
                    if (null != adListener) {
                        adListener.onAdLoaded();

                    }

                } else {
                    mInterstitialAd = new InterstitialAd(context);
                    mInterstitialAd.setAdUnitId(AD_ID);
                    AdRequest adRequest;
                    if (isTest) {
                        String android_id = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
                        String deviceId = md5(android_id).toUpperCase();
                        adRequest = new AdRequest.Builder().addTestDevice(deviceId).build();
                    } else {
                        adRequest = new AdRequest.Builder().build();
                    }
                    mInterstitialAd.loadAd(adRequest);
                    mInterstitialAd.setAdListener(new com.google.android.gms.ads.AdListener() {
                        @Override
                        public void onAdClosed() {
                            if (null != adListener) {
                                adListener.onAdClosed();
                            }
                        }

                        @Override
                        public void onAdOpened() {

                            if (null != adListener) {

                                adListener.onAdOpen();
                            }
                        }

                        @Override
                        public void onAdLoaded() {

                            if (null != adListener) {

                                adListener.onAdLoaded();
                            }
                        }

                        @Override
                        public void onAdFailedToLoad(int errorCode) {
                            Log.e("PIXNET AD", "==============================onAdFailedToLoad  " + getErrorMessage(errorCode));
                            if (null != adListener) {
                                adListener.onAdFailedToLoad();
                            }
                        }
                    });
                }

            }
        }, sizeType);

    }

    //取得原生廣告用的資訊-是否要給user待議
    private static void getADDataItem(Context context) {

        if (bannerList.size() > 0) {
            myGetBannerItem.getData(bannerList.get(makeRandom(bannerList.size())));
        } else {
            downloadADDataList(context);

        }

    }

    //下載廣告資料
    private static void downloadADDataList(Context context) {
        if (null == PixnetAd.getUnitid()) {
            ErrorLog.noID(context.getClass().toString());
            return;
        }
//        if (null==sizeType){
//            Log.e("PIXNET AD","Size Type is null!");
//            return;
//        }else{
//            Log.v("PIXNET AD","Size Type is "+sizeType);
//        }
        new PixnetAdDownloadTask().getInstance().getPixnetADListData(context, new PixnetADDownloadDataCallback() {
            @Override
            public void serverRequest_Callback(Object object) {
                if (object instanceof PixnetAdData) {
                    PixnetAdData data = (PixnetAdData) object;
                    if (null != data.ad_slots && null != data.ad_slots.get(0).ad_list && data.ad_slots.get(0).ad_list.size() > 0) {
                        bannerList = data.ad_slots.get(0).ad_list;
                        if (null != myGetBannerItem) {
                            myGetBannerItem.getData(bannerList.get(makeRandom(bannerList.size())));
                            return;
                        }
                    }
                } else {
                    myGetBannerItem.getData(null);
                }


            }
        });

    }

    private static int makeRandom(int size) {
        return (int) (Math.random() * size);
    }

    public static void getADDataListener(Context context, GetADData getBannerItem) {

        myGetBannerItem = getBannerItem;
        getADDataItem(context);
    }

    public interface GetADData {
        void getData(PixnetAdItem data);
    }

    public static void setAdListener(AdListener adListener) {

        PixnetAd.adListener = adListener;

    }

    //廣告關閉監聽
    public interface AdListener {
        void onAdClosed();

        void onAdOpen();

        void onAdFailedToLoad();

        void onAdLoaded();
    }


    private Dialog makeDialog(final PixnetAdSlot data, final Context context) {
        if (null != adDialog) {
            adDialog.dismiss();
            adDialog = null;
        }

        adDialog = new Dialog(context, R.style.ad_dialog);
        adDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        adDialog.setCancelable(false);
        final PixnetAdItem item = data.ad_list.get(0);


        LayoutInflater mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View view = mInflater.inflate(R.layout.dialog_ad_view, null);

        NetworkImageView adIV = (NetworkImageView) view.findViewById(R.id.adIV);
        ImageView deleteIV = (ImageView) view.findViewById(R.id.deleteIV);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();


        double height = displayMetrics.heightPixels;
        double width = displayMetrics.widthPixels;
        String[] afterSplit = data.ad_size.split("x");

        int ad_h, ad_w;


        ad_h = Integer.valueOf(afterSplit[1].trim());
        ad_w = Integer.valueOf(afterSplit[0].trim());
        if (height > width) {
            height = ((width / ad_w)) * ad_h;

        } else {
            width = ((height / ad_h)) * ad_w;

        }

        adIV.setBackgroundColor(0x000000);


        adIV.setLayoutParams(new RelativeLayout.LayoutParams((int) width, (int) height));
        adIV.setPadding(20, 20, 20, 20);
        adIV.setImageUrl("http:" + item.file, Helper.getImageLoader(Helper.getRequestQueueNoCookie(context)));

//                    builder.setView(view);
        adDialog.setContentView(view);

//                    saveDialogList.add(data.ad_slots.get(0).ad_list.get(0).hashid);
//                    preferences.edit().putString("DIALOG_DATA_LIST", new Gson().toJson(saveDialogList)).commit();
//                    final Dialog ad_dialog = builder.create();

        adIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                adDialog.dismiss();
                Intent ie = new Intent(Intent.ACTION_VIEW, Uri.parse("http:" + item.click_url));
                context.startActivity(ie);
                if (null != adListener) {
                    adListener.onAdOpen();

                }
            }
        });
        deleteIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                adDialog.dismiss();
                if (null != adListener) {
                    adListener.onAdClosed();

                }
            }
        });


        return adDialog;
    }

    //柱姊很重要！

    /**
     * @param id your ID
     */
    public static void setUnitid(String id) {
        PixnetAd.id = id;

    }

    /**
     * @param sizeType set banner or cover size. Ex:BANNER, LARGE_BANNER, MEDIUM_RECTANGLE, FULL_BANNER, LEADERBOARD, INTERSTITIAL, COVER, NATIVE.
     */
    public static void setSize(String sizeType) {
        PixnetAd.sizeType = sizeType;

    }

    public static String getUnitid() {
        return id;
    }

    public static boolean isTestMode() {
        return isTest;
    }

    public static void setTestMode(boolean testMode) {
        isTest = testMode;
    }

    public static final String md5(final String s) {
        try {
            // Create MD5 Hash
            MessageDigest digest = java.security.MessageDigest
                    .getInstance("MD5");
            digest.update(s.getBytes());
            byte messageDigest[] = digest.digest();

            // Create Hex String
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; i++) {
                String h = Integer.toHexString(0xFF & messageDigest[i]);
                while (h.length() < 2)
                    h = "0" + h;
                hexString.append(h);
            }
            return hexString.toString();

        } catch (NoSuchAlgorithmException e) {

        }
        return "";
    }

    private static String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case 0:
                return "Something happened internally; for instance, the Activity may have been destroyed mid-refresh.";

            case 1:
                return "The ad request is invalid.";

            case 2:
                return "The ad request was unsuccessful due to network connectivity.";

            case 3:
                return "The ad request is successful, but no ad was returned due to lack of ad inventory.";

            default:
                return "Other error.";
        }

    }
}
