package android.pixnet.net.ad_sdk.util;

import android.content.Context;
import android.pixnet.net.ad_sdk.download.PreferencesCookieStore;
import android.util.Log;
import android.widget.Toast;

import com.android.volley.RequestQueue;
import com.android.volley.toolbox.HttpClientStack;
import com.android.volley.toolbox.HttpStack;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Volley;

import org.apache.http.client.CookieStore;
import org.apache.http.impl.client.DefaultHttpClient;

public class Helper {

    private final static boolean DEBUG = true;

    private static RequestQueue rq, reNoCookie;
    private static ClearableImageCache imgCache;
    private static ImageLoader imgLoader;

    public static RequestQueue getRequestQueue(Context c) {
        if (rq == null) {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            CookieStore cookieStore = new PreferencesCookieStore(c);
            httpclient.setCookieStore(cookieStore);
            HttpStack httpStack = new HttpClientStack(httpclient);


            rq = Volley.newRequestQueue(c, httpStack);

        }

//        if (rq == null) {
//
//            rq = Volley.newRequestQueue(c);
//
//
//        }
        return rq;
    }

    public static RequestQueue getRequestQueueNoCookie(Context c) {
        if (reNoCookie == null) {

            reNoCookie = Volley.newRequestQueue(c);


        }
        return reNoCookie;
    }

//    public static RequestQueue getRequestQueueNoCookie(Context c) {
//        if (rq == null) {
//            DefaultHttpClient httpclient = new DefaultHttpClient();
//            CookieStore cookieStore = new PreferencesCookieStore(c);
//            httpclient.setCookieStore(cookieStore);
//            HttpStack httpStack = new HttpClientStack(httpclient);
//
//
//            rq = Volley.newRequestQueue(c, httpStack);
//
//        }
//        return rq;
//    }

    public static ClearableImageCache getImageCache() {
        if (imgCache == null)
            imgCache = new ClearableImageCache();
        return imgCache;
    }

    public static ImageLoader getImageLoader(RequestQueue rq) {
        if (imgLoader == null) {
            imgLoader = new ImageLoader(rq, getImageCache());
        }
        return imgLoader;
    }


    public static void toast(Context c, String msg) {
        Toast
                .makeText(c, msg, Toast.LENGTH_SHORT)
                .show();
    }

    public static void log(String msg) {
        if (DEBUG)
            Log.d("DEBUG", msg);
    }


}
