package android.pixnet.net.ad_sdk.download;

import android.content.Context;
import android.pixnet.net.ad_sdk.modle.PixnetAdData;
import android.pixnet.net.ad_sdk.util.Helper;
import android.util.Log;

import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.google.gson.Gson;

/**
 * Created by abreu on 15/9/24.
 * Copyright (c) 2015, p42106@gmail.com All Rights Reserved.
 */
public class NewPixnetADSendDataUtil {

    private Context context;
    private RequestQueue mRequestQueue;


    public <T> NewPixnetADSendDataUtil(Context context, final String API_url,
                                       final PixnetADDownloadDataCallback dataCallback,
                                       final Class<T> classname, Boolean saveCookie, String sizeType) {

        this.context = context;


        if (saveCookie) {
            mRequestQueue = Helper.getRequestQueue(context);
        } else {
            mRequestQueue = Helper.getRequestQueueNoCookie(context);
        }


        StringRequest strReq = new StringRequest(
                API_url, new Response.Listener<String>() {

            @Override
            public void onResponse(String response) {


                Log.e("=====AD 取得資料===== ", API_url + " \n " + response);
//                T data = JSON.parseObject(response, classname);
                Gson gson = new Gson();
                T data = gson.fromJson(response, classname);
                if (((PixnetAdData) data).error) {
                    Log.e("PIXNET AD", ((PixnetAdData) data).message.get(0));
                }
                dataCallback.serverRequest_Callback(data);
            }
        }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {
                Log.e("PIXNET AD", "Data == " + error.getMessage());
                dataCallback.serverRequest_Callback(null);
            }
        });


        Log.e("=====AD send url=====", API_url);

        mRequestQueue.add(strReq);
    }


}
