package cn.lsmya.helper

import android.util.Log

/**
 * 日志工具类
 */
class LogHelper private constructor() {
    companion object {
        private const val mTag = " LOG "

        /**
         * 打印日志：debug
         */
        @JvmStatic
        fun d(msg: String) {
            d(
                mTag,
                msg
            )
        }

        /**
         * 打印日志：error
         */
        @JvmStatic
        fun e(msg: String) {
            e(
                mTag,
                msg
            )
        }

        /**
         * 打印日志：info
         */
        @JvmStatic
        fun i(msg: String) {
            i(
                mTag,
                msg
            )
        }

        /**
         * 打印日志：verbose
         */
        @JvmStatic
        fun v(msg: String) {
            v(
                mTag,
                msg
            )
        }

        /**
         * 打印日志：debug
         */
        @JvmStatic
        fun d(tag: String, msg: String) {
            if (Tools.debug()) {
                Log.d(tag, msg)
            }
        }

        /**
         * 打印日志：error
         */
        @JvmStatic
        fun e(tag: String, msg: String) {
            if (Tools.debug()) {
                Log.e(tag, msg)
            }
        }

        /**
         * 打印日志：info
         */
        @JvmStatic
        fun i(tag: String, msg: String) {
            if (Tools.debug()) {
                Log.i(tag, msg)
            }
        }

        /**
         * 打印日志：verbose
         */
        @JvmStatic
        fun v(tag: String, msg: String) {
            if (Tools.debug()) {
                Log.v(tag, msg)
            }
        }

    }
}