package cn.lsmya.helper

import android.util.Log
import java.text.SimpleDateFormat
import java.util.*

/**
 * 时间格式化
 */
class TimeHelper private constructor() {

    companion object {
        @JvmStatic
        val DAY = 24 * 60 * 60 * 1000F

        @JvmStatic
        val HOUR = 60 * 60 * 1000F

        @JvmStatic
        val YYYY_FORMAT = SimpleDateFormat("yyyy", Locale.getDefault())

        @JvmStatic
        fun todayYyyy(): String {
            return YYYY_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyy(date: Date): String {
            return YYYY_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyy(times: Long): String {
            return YYYY_FORMAT.format(Date(times))
        }

        @JvmStatic
        val YYYYMMDD_FORMAT = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault())

        @JvmStatic
        fun todayYyyyMmDd(): String {
            return YYYYMMDD_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyyMmDd(date: Date): String {
            return YYYYMMDD_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyyMmDd(times: Long): String {
            return YYYYMMDD_FORMAT.format(Date(times))
        }

        @JvmStatic
        val YYYYMMDDHHMM_FORMAT = SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault())

        @JvmStatic
        fun todayYyyyMmDdHhMm(): String {
            return YYYYMMDDHHMM_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyyMmDdHhMm(date: Date): String {
            return YYYYMMDDHHMM_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyyMmDdHhMm(times: Long): String {
            return YYYYMMDDHHMM_FORMAT.format(Date(times))
        }

        @JvmStatic
        val YYYYMMDDHHMMSS_FORMAT = SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault())

        @JvmStatic
        fun todayYyyyMmDdHhMmSs(): String {
            return YYYYMMDDHHMMSS_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayYyyyMmDdHhMmSs(date: Date): String {
            return YYYYMMDDHHMMSS_FORMAT.format(date)
        }

        @JvmStatic
        fun todayYyyyMmDdHhMmSs(times: Long): String {
            return YYYYMMDDHHMMSS_FORMAT.format(Date(times))
        }

        @JvmStatic
        val HHMMSS_FORMAT = SimpleDateFormat("HH:mm:ss", Locale.getDefault())

        @JvmStatic
        fun todayHhMmSs(): String {
            return HHMMSS_FORMAT.format(Date())
        }

        @JvmStatic
        fun todayHhMmSs(date: Date): String {
            return HHMMSS_FORMAT.format(date)
        }

        @JvmStatic
        fun todayHhMmSs(times: Long): String {
            return HHMMSS_FORMAT.format(Date(times))
        }

        @JvmStatic
        fun timeToTimestamp(time: String, sdf: SimpleDateFormat): Long {
            return sdf.parse(time).time
        }

        @JvmStatic
        fun dateCalculation(
            startTime: String,
            stopTime: String,
            sdf: SimpleDateFormat,
            unit: Float
        ): Float {
            var fTime: Date? = null
            var sTime: Date? = null
            try {
                fTime = sdf.parse(startTime)
                sTime = sdf.parse(stopTime)
            } catch (e: Exception) {
                e.printStackTrace()
                Log.e("TIME_HELPER", "日期型字符串格式错误")
            }
            if (sTime!!.time > fTime!!.time) {
                return (sTime.time - fTime.time) / unit
            } else {
                return (fTime.time - sTime.time) / unit
            }
        }
    }

}