package cn.lsmya.helper;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;

import java.util.ArrayList;
import java.util.List;

public class HandlerHelper implements Handler.Callback {

    private static HandlerHelper instance;

    private final Handler mHandler = new Handler(Looper.getMainLooper(), this);
    private final List<OnHandlerCallback> mListenersList = new ArrayList<>();

    public void send(int what) {
        mHandler.sendMessage(mHandler.obtainMessage(what));
    }

    public void send(int what, Object object) {
        mHandler.sendMessage(mHandler.obtainMessage(what, object));
    }

    public void addListener(OnHandlerCallback callback) {
        synchronized (mListenersList) {
            if (callback != null && !mListenersList.contains(callback)) {
                mListenersList.add(callback);
            }
        }
    }

    public void removeListener(OnHandlerCallback callback) {
        synchronized (mListenersList) {
            if (callback != null) {
                mListenersList.remove(callback);
            }
        }
    }

    @Override
    public boolean handleMessage(Message msg) {
        int what = msg.what;
        Object obj = msg.obj;
        synchronized (mListenersList) {
            if (mListenersList.size() != 0) {
                for (final OnHandlerCallback callback : mListenersList) {
                    callback.handleMessage(what, obj);
                }
            }
        }
        return true;
    }

    public static HandlerHelper getInstance() {
        if (instance == null) {
            synchronized (HandlerHelper.class) {
                if (instance == null) {
                    instance = new HandlerHelper();
                }
            }
        }
        return instance;
    }

    public interface OnHandlerCallback {
        void handleMessage(int what, Object object);
    }

}
