package cn.lsmya.helper.viewpager;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ViewPagerAdapter extends FragmentStatePagerAdapter {

    private List<Fragment> mFragments = null;
    private List<String> mTitles = null;

    public void setFragmentList(Fragment... fragments) {
        if (mFragments == null) {
            mFragments = new ArrayList<>();
        }
        mFragments = Arrays.asList(fragments);
        notifyDataSetChanged();
    }

    public void addFragment(Fragment fragment) {
        if (mFragments == null) {
            mFragments = new ArrayList<>();
        }
        mFragments.add(fragment);
        notifyDataSetChanged();
    }

    public void setTitles(String... titles) {
        if (mTitles == null) {
            mTitles = new ArrayList<>();
        }
        mTitles = Arrays.asList(titles);
    }

    public void addTitle(String title) {
        if (mTitles == null) {
            mTitles = new ArrayList<>();
        }
        mTitles.add(title);
    }

    public ViewPagerAdapter(FragmentManager fm) {
        super(fm);
    }

    @Override
    public Fragment getItem(int i) {
        return mFragments.get(i);
    }

    @Override
    public int getCount() {
        return mFragments == null ? 0 : mFragments.size();
    }

    @Nullable
    @Override
    public CharSequence getPageTitle(int position) {
        if (mTitles != null && mTitles.size() == getCount()) {
            return mTitles.get(position);
        }
        Fragment fragment = mFragments.get(position);
        if (fragment instanceof PageTitle) {
            PageTitle pageTitle = (PageTitle) fragment;
            return pageTitle.getPageTitle();
        }
        return "";
    }

    public interface PageTitle {
        CharSequence getPageTitle();
    }
}
