package cn.lsmya.helper.fragment;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class BaseFragment extends LazyFragment {

    @Override
    @LayoutRes
    protected abstract int getLayoutId();

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        findView();
        initView();
    }

    /**
     * 绑定控件
     */
    protected void findView() {

    }

    /**
     * 初始化控件
     */
    protected abstract void initView();

}
