package cn.lsmya.helper.mvp;

/**
 * @author lsm
 */
public abstract class BaseMvpPresenter<V, M> {
    /**
     * View接口
     */
    private V mView;
    private M mModel;

    /**
     * 绑定view，一般在初始化中调用该方法
     */
    void attachView(V mvpView, M model) {
        this.mView = mvpView;
        this.mModel = model;
    }

    /**
     * 断开view，一般在onDestroy中调用
     */
    void detachView() {
        this.mView = null;
    }

    /**
     * 是否与View建立连接
     * 每次调用业务请求的时候都要出先调用方法检查是否与View建立连接
     */
    public boolean isViewAttached() {
        return mView != null;
    }

    public V getMvpView() {
        return mView;
    }

    public M getModel() {
        return mModel;
    }
}