package cn.lsmya.helper.mvp;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import cn.lsmya.helper.fragment.LazyFragment;
import cn.lsmya.helper.util.ClassReflectHelper;

public abstract class BaseMvpFragment<P extends BaseMvpPresenter, M> extends LazyFragment implements BaseMvpView {

    private P mPresenter;
    private M mModel;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mPresenter = ClassReflectHelper.getT(this, 0);
        mModel = ClassReflectHelper.getT(this, 1);
        if (getPresenter() != null && mModel != null) {
            getPresenter().attachView(this, mModel);
        }
        findView();
        initView();
    }

    /**
     * 绑定控件
     */
    protected void findView() {

    }

    /**
     * 初始化控件
     */
    protected abstract void initView();

    @Override
    public void onDestroy() {
        if (getPresenter() != null) {
            getPresenter().detachView();
        }
        super.onDestroy();
    }

    public P getPresenter() {
        return mPresenter;
    }

}
