package cn.lsmya.helper.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;

import cn.lsmya.helper.ToolsHelper;
import cn.lsmya.helper.R;

/**
 * Toast提示
 *
 * @author lsm
 */
public class ToastHelper {

    private static Toast mToast;

    public static void showText(String message) {
        showText(message, Toast.LENGTH_SHORT);
    }

    public static void showText(String message, int duration) {
        showText(message, duration, Color.GRAY);
    }

    public static void showText(String message, int duration, int backgroundColor) {
        showText(message, duration, backgroundColor, Gravity.BOTTOM);
    }

    public static void showText(String message, int duration, int backgroundColor, int gravity) {
        show(ToolsHelper.getContext(), message, duration, false, backgroundColor, 0, gravity);
    }

    public static void showTextWithIcon(String message, int iconResId) {
        showTextWithIcon(message, iconResId, Color.GRAY);
    }

    public static void showTextWithIcon(String message, int iconResId, int backgroundColor) {
        showTextWithIcon(message, iconResId, backgroundColor, Toast.LENGTH_SHORT);
    }

    public static void showTextWithIcon(String message, int iconResId, int backgroundColor, int duration) {
        showTextWithIcon(message, iconResId, backgroundColor, duration, Gravity.BOTTOM);
    }

    public static void showTextWithIcon(String message, int iconResId, int backgroundColor, int duration, int gravity) {
        show(ToolsHelper.getContext(), message, duration, true, backgroundColor, iconResId, gravity);
    }

    public static void showSuccess(String message) {
        showSuccess(message, Toast.LENGTH_SHORT);
    }

    public static void showSuccess(String message, int duration) {
        showSuccess(message, duration, Color.parseColor("#388E3C"));
    }

    public static void showSuccess(String message, int duration, int backgroundColor) {
        showSuccess(message, duration, backgroundColor, Gravity.BOTTOM);
    }

    public static void showSuccess(String message, int duration, int backgroundColor, int gravity) {
        show(ToolsHelper.getContext(), message, duration, true, backgroundColor, R.drawable.kit_toast_success, gravity);
    }

    public static void showError(String message) {
        showError(message, Toast.LENGTH_SHORT);
    }

    public static void showError(String message, int duration) {
        showError(message, duration, Color.parseColor("#FD4C5B"));
    }

    public static void showError(String message, int duration, int backgroundColor) {
        showError(message, duration, backgroundColor, Gravity.BOTTOM);
    }

    public static void showError(String message, int duration, int backgroundColor, int gravity) {
        show(ToolsHelper.getContext(), message, duration, true, backgroundColor, R.drawable.kit_toast_error, gravity);
    }


    @SuppressLint("InflateParams")
    private static void show(Context context, @NonNull String message, int duration, boolean showIcon, int backgroundColor, int iconResId, int gravity) {
        mToast = new Toast(context);
        View inflate = LayoutInflater.from(context).inflate(R.layout.kit_toast, null);
        ImageView toastIcon = inflate.findViewById(R.id.kit_toast_icon);
        TextView toastText = inflate.findViewById(R.id.kit_toast_text);
        toastText.setText(message);
        if (showIcon) {
            toastIcon.setVisibility(View.VISIBLE);
            toastIcon.setImageResource(iconResId);
        }
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadius(65);
        drawable.setColor(backgroundColor);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            inflate.setBackground(drawable);
        } else {
            inflate.setBackgroundDrawable(drawable);
        }
        mToast.setView(inflate);
        mToast.setDuration(duration);
        if (gravity != Gravity.BOTTOM) {
            mToast.setGravity(gravity, 0, 0);
        }
        mToast.show();
    }

}
