package cn.lsmya.helper.mvp;

import android.os.Bundle;

import androidx.annotation.Nullable;

import cn.lsmya.helper.activity.BaseToolBarActivity;
import cn.lsmya.helper.util.ClassReflectHelper;

public abstract class BaseMvpActivity<P extends BaseMvpPresenter, M> extends BaseToolBarActivity implements BaseMvpView {

    private P mPresenter;
    private M mModel;

    /**
     * 获取布局id
     *
     * @return 布局id
     */
    public abstract int getLayout();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(getLayout());
        mPresenter = ClassReflectHelper.getT(this, 0);
        mModel = ClassReflectHelper.getT(this, 1);
        if (getPresenter() != null && mModel != null) {
            getPresenter().attachView(this, mModel);
        }
    }

    @Override
    protected void onDestroy() {
        if (getPresenter() != null) {
            getPresenter().detachView();
        }
        super.onDestroy();
    }

    public P getPresenter() {
        return mPresenter;
    }

}